/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_pwramp.cpp
 * AUTHOR:
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>

#include "aud_sinkmgr_pwramp.h"
#include "Booster/Booster.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/aud_sinkmgr_pwramp_AIVI.cpp.trc.h"
#endif

// Includes all header files for FI of DP-component
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_audio_if.h"

// trigger self-termination of wake-up-tracking thread
#define  EVENT_MASK_STOP_WUP_THREAD   DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_32

/******************************************************************************/
/* GLOBAL VARIABLES                                                           */
/******************************************************************************/
static tU8 aud_ubSinkState;
static tU8 aud_ubExtBooster;
static tU8 u8LowPowerActive;
static tU8 u8HighPowerActive;

/******************************************************************************/
/* METHODS                                                                    */
/******************************************************************************/

/*******************************************************************************
 *  Constructor.
 *******************************************************************************/
aud_sinkmgr_pwramp_AIVI::aud_sinkmgr_pwramp_AIVI(fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* pStreamMute)
   : IF_MessageObserver<PO_MessageConfig::enID>("aud_sinkmgr_pwramp_AIVI")
   , muteRegId(0)
   , userMuteRegId(0)
   , m_pStreamMute(pStreamMute)
   , m_pUserMute(pStreamMute)
   , m_poMainAppl(poMainAppl)
   , m_enLastAccStatus(AUD_SINKMGR_ACC_UNKNOWN)
   , m_hDevWup(OSAL_IOOpen(OSAL_C_STRING_DEVICE_WUP, OSAL_EN_READWRITE))
   , m_hWupEvents(OSAL_C_INVALID_HANDLE)
   , m_hWupThreadId(OSAL_ERROR)
   , m_hWupShutdownSync(OSAL_C_INVALID_HANDLE)
   , m_enAudioState(EN_AUDIO_STATE_OFF)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_AIVI() entered."));

  m_bRecoveryFromLowVoltage = FALSE;
  if(NULL == pStreamMute)
  {
    FATAL_M_ASSERT_ALWAYS();
  }
  else
  {
    muteRegId = m_pStreamMute->registerForStreamMute(StreamMute_IF::INTERNAL_BEH, this);
    userMuteRegId = m_pUserMute->registerForStreamMute(StreamMute_IF::INTERNAL_BEH, this);
  }

  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();

  // validate connection to wake-up device
  if (OSAL_ERROR == m_hDevWup)
     ETG_TRACE_FATAL(( " E R R O R : detected in OSAL_IOOpen of DEV_WUP" ))
}


/*******************************************************************************
 *  Destructor.
 *******************************************************************************/
aud_sinkmgr_pwramp_AIVI::~aud_sinkmgr_pwramp_AIVI()
{
  ETG_TRACE_USR4(("~aud_sinkmgr_pwramp() entered."))
    pPO->POMessages->DeRegisterObserver(this);
  vShutdownWupThread();

  // disconnect from wake-up device
  (void)OSAL_s32IOClose(m_hDevWup);

  m_poMainAppl  = NULL;
  m_pStreamMute = NULL;
    m_pUserMute  = NULL;
  pPO = NULL;
}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vInit()
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp vInit() entered."));

  aud_sinkmgr_Gpio_If::vStart(this);

  vLaunchWupThread();

//  vCheckAccStatus();

  aud_ubSinkState    = AUD_SINK_STATE_OFF;
  aud_ubExtBooster   = SOUND_CONFIG_ITEM_VALUE_UNDEF;
  u8LowPowerActive   = 0;
  u8HighPowerActive   = 0;

  vSetBoosterControl( AUD_BOOSTER_OFF);

  ETG_TRACE_USR4(("aud_sinkmgr_pwramp vInit() completed."));
}

/********************************************************************************
 * vSetLowPowerFlag().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vSetLowPowerFlag(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp vSetLowPowerFlag() entered.ubOnOff = %u",ubOnOff));
  //previously low power was active, and now it switched OFF
  if(u8LowPowerActive && !ubOnOff)
  {
    m_bRecoveryFromLowVoltage = TRUE;
  }
  //Update local variables
  u8LowPowerActive = ubOnOff;
  vCheckPwrAmp();//m_bRecoveryFromLowVoltage flag is evaluated in m_bRecoveryFromLowVoltage
  //Clear the flag will be done in vCheckPwramp Function
  //m_bRecoveryFromLowVoltage = FALSE;
}

/********************************************************************************
 * vSetHighPowerFlag().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vSetHighPowerFlag(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp vSetHighPowerFlag() entered.ubOnOff = %u",ubOnOff));
  u8HighPowerActive = ubOnOff;
  vCheckPwrAmp();
}

/********************************************************************************
 * ubGetLowPowerFlag().
 *******************************************************************************/
tU8 aud_sinkmgr_pwramp_AIVI::ubGetLowPowerActiveFlag(tVoid)
{
   return u8LowPowerActive;
}
/********************************************************************************
 * vOnApplicationClose().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vOnApplicationClose()
{
  ETG_TRACE_USR4(("vOnApplicationClose() entered."));

}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::vAddObserver()
{

  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_AIVI::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("aud_sinkmgr_pwramp_AIVI::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AudioState);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::MessageNotification(PO_MessageConfig::enID MsgId)
{

  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_AIVI::MessageNotification entered. "));

  switch(MsgId)
  {
  case PO_MessageConfig::ID_AudioState:
    {
      const ID_AudioState* pMsg = pPO->POMessages->QueryMessage<ID_AudioState>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("AudioState status: 0x%4x.", pMsg->AudioState));
      m_enAudioState = pMsg->AudioState;
      vCheckPwrAmp();
      break;
    }
    default :
      break;
  }
}

/********************************************************************************
 * vCheckPwrAmp(tVoid)
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vCheckPwrAmp(tVoid)
{
  tBool bIsAdr3Running = vd_adr3_If::bGetAdr3StateRunning();
  tBool bIsBoosterOnTimerRunning = aud_sinkmgr_timer::bGetBoosterOnTimerRunning();
  ETG_TRACE_USR4(("vCheckPwrAmp() entered.aud_ubSinkState = %u, u8LowPowerActive = %u, u8HighPowerActive = %u, ADR3 running = %u, Bosster-ON timer running = %u"
        , aud_ubSinkState, u8LowPowerActive, u8HighPowerActive, bIsAdr3Running, bIsBoosterOnTimerRunning))

  switch(aud_ubSinkState)
  {
  case AUD_SINK_STATE_OFF:

      if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      ETG_TRACE_USR4(("vCheckPwrAmp() AUD_SINK_STATE_OFF Preconditions not met yet"))
      return;
    }

    //set sink mute
    vMuteSink();
    vd_adr3Msg_If::vReloadADRData();

    aud_ubSinkState = AUD_SINK_STATE_ON_IP;

    vStartTimer(AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER);
    //Clear recovery from low voltage flag
    m_bRecoveryFromLowVoltage = FALSE;

    //set ADR power state to ON
    {
      tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_ON;
      ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
    }

    break;

  case AUD_SINK_STATE_ON_IP:
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if ( ! bIsBoosterOnTimerRunning)
    {
      vCheckPwrAmpTmr();
    }
    break;

  case AUD_SINK_STATE_ON:
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if ( (m_enAudioState == EN_AUDIO_STATE_ON) || (m_enAudioState == EN_AUDIO_STATE_LIMITED) )
    {
      ETG_TRACE_USR4(("vCheckPwrAmp() AUDIO_STATE_ON.aud_ubSinkState = %u ", aud_ubSinkState));
      aud_ubSinkState = AUD_SINK_STATE_DEMUTE_IP;

      vSetBoosterControl( AUD_BOOSTER_ON);

      vStartTimer(AUD_SINKMANAGER_TIMER_ID_DEMUTE);
    }
    break;

  case AUD_SINK_STATE_DEMUTE_IP:
  case AUD_SINK_STATE_MUTE_IP:
    {
      if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
      {
        aud_ubSinkState = AUD_SINK_STATE_OFF;
        vSetBoosterControl( AUD_BOOSTER_OFF);
      }
    }
    break;
  case AUD_SINK_STATE_DEMUTED:
    if ( (m_enAudioState != EN_AUDIO_STATE_ON ) && (m_enAudioState != EN_AUDIO_STATE_LIMITED))
    {
      //aud_ubSinkState = AUD_SINK_STATE_MUTE_IP;
      aud_ubSinkState = AUD_SINK_STATE_MUTED;

      aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_DEMUTE);
      vMuteSink();

      vStartTimer(AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY);
      //aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF, AUD_SINKMANAGER_TIMER_BOOSTER_OFF_INTERVAL);
      vSetBoosterControl( AUD_BOOSTER_OFF);

    }
    else if((u8LowPowerActive)||(u8HighPowerActive)||
        (bIsAdr3Running == FALSE))
    {
      vSetBoosterControl( AUD_BOOSTER_OFF);
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    break;

  case AUD_SINK_STATE_MUTED:
    {
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if ( (m_enAudioState == EN_AUDIO_STATE_ON) || (m_enAudioState == EN_AUDIO_STATE_LIMITED) )
    {
      aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF);
      aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY);

      aud_ubSinkState = AUD_SINK_STATE_DEMUTE_IP;
      vSetBoosterControl( AUD_BOOSTER_ON);
      vMuteSink();
      //Start timer to demute
      vStartTimer(AUD_SINKMANAGER_TIMER_ID_DEMUTE);
    }
    break;
    }
  case AUD_SINK_STATE_STANDBY:
    {
    if (((m_enAudioState == EN_AUDIO_STATE_ON) || (m_enAudioState == EN_AUDIO_STATE_LIMITED)) && (bIsAdr3Running == TRUE))
    {
      aud_ubSinkState = AUD_SINK_STATE_ON_IP;
      //set ADR power state to ON
      tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_ON;
      ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

      vStartTimer(AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER);

      //check pending messages
      vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);
    }
    else if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if(aud_sinkmgr_main::ubGetApplicationState() == AUD_APP_PWR_EVENT_APP_OFF)
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    break;
    }
  default:
    break;

  }
  ETG_TRACE_USR4(("vCheckPwrAmp() end.   aud_ubSinkState = %u ", aud_ubSinkState));
}

/********************************************************************************
 * tVoid vCheckPwrAmpTmr(tVoid)
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vCheckPwrAmpTmr(tVoid)
{
  tBool bIsAdr3Running = vd_adr3_If::bGetAdr3StateRunning();
  tBool bIsBoosterOnTimerRunning = aud_sinkmgr_timer::bGetBoosterOnTimerRunning();
  tBool bIsDemuteTimerRunning = aud_sinkmgr_timer::bGetDemuteTimerRunning();
  ETG_TRACE_USR4(("vCheckPwrAmpTmr() entered. aud_ubSinkState = %u, u8LowPowerActive = %u, u8HighPowerActive = %u,"
        "ADR3 running = %u, Bosster-ON timer running = %u, demute timer running = %u"
        , aud_ubSinkState, u8LowPowerActive, u8HighPowerActive, bIsAdr3Running, bIsBoosterOnTimerRunning, bIsDemuteTimerRunning))

  switch(aud_ubSinkState)
  {
  case AUD_SINK_STATE_ON_IP:
    //low power
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running== FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if((!(bIsBoosterOnTimerRunning) ||(vd_adr3Msg_powerState::ubGetAdr3PowerState() == EN_AUDIO_ADR_POWER_STATE_ON)))
    {
      aud_ubSinkState = AUD_SINK_STATE_ON;
      aud_sinkmgr_timer::vStopTimer( AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER);
      vCheckPwrAmp();
    }

    break;
  case AUD_SINK_STATE_DEMUTE_IP:
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      vSetBoosterControl( AUD_BOOSTER_OFF);
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if ( (m_enAudioState != EN_AUDIO_STATE_ON) && (m_enAudioState != EN_AUDIO_STATE_LIMITED) )
    {
      aud_ubSinkState = AUD_SINK_STATE_MUTE_IP;

      aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_DEMUTE);

      vStartTimer(AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY);
      //aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF, AUD_SINKMANAGER_TIMER_BOOSTER_OFF_INTERVAL);
      vSetBoosterControl( AUD_BOOSTER_OFF);
      aud_ubSinkState = AUD_SINK_STATE_MUTED;

    }
    else if(bIsDemuteTimerRunning)
    {
      //wait for timer to expire
    }
    else
    {
      aud_ubSinkState = AUD_SINK_STATE_DEMUTED;
      vDemuteSink();
    }
    break;

  case AUD_SINK_STATE_MUTE_IP:
    vSetBoosterControl( AUD_BOOSTER_OFF);
    aud_ubSinkState = AUD_SINK_STATE_MUTED;
    if((u8LowPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    break;

  case AUD_SINK_STATE_MUTED:
    aud_ubSinkState = AUD_SINK_STATE_STANDBY;
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else
    {
      //switch ADRPowerState to STANDBY
      tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_STANDBY;
      ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
    }
    break;

  default:
    break;
  }
  ETG_TRACE_USR4(("vCheckPwrAmpTmr() end.   aud_ubSinkState = %u ", aud_ubSinkState))
}

/********************************************************************************
 * vSetBoosterControl(tBool ubOnOff)
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vSetBoosterControl(tBool ubOnOff)
{
  ETG_TRACE_USR4(("vSetBoosterControl() entered.ubOnOff = %u ", ubOnOff));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#define AUTHORIZED 3
#define NOTAUTHORIZED 0
  #ifdef CSM_C_ASIG_TX_Audio_WorkingAuthorize
  tU8 pabData;
    ubOnOff == AUD_BOOSTER_OFF ?  pabData = NOTAUTHORIZED : pabData = AUTHORIZED;
  m_poMainAppl->m_poCsmHandler->vTransmitCsmBroadcastSignal(&pabData,1,CSM_C_ASIG_TX_Audio_WorkingAuthorize,CSM_C_TX_IMMEDIATELY);
  #endif
#endif
  IDSetBoosterState oMsg(ubOnOff);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMsg);
}


/********************************************************************************
 * vMuteSink
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vMuteSink(tVoid)
{
  ETG_TRACE_USR4(("vMuteSink() entered with muteRegId = %u.", muteRegId))
  StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_MUTE;
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MAIN);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX1);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX2);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX3);
}

/********************************************************************************
 * vDemuteSink
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_AIVI::vDemuteSink(tVoid)
{
  ETG_TRACE_USR4(("vDemuteSink() entered with muteRegId = %u.", muteRegId))
  StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_DEMUTE;
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MAIN);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX1);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX2);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX3);
}

/********************************************************************************
 * vSetSpecialMute()
 *******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::vSetSpecialMute(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("vSetSpecialMute()ubOnOff=%u",(tU8) ubOnOff));

  if(ubOnOff == 1)
  {
    vMuteSink();
  }
  else
  {
    vDemuteSink();
  }
}

/********************************************************************************
 * vSetUserMute()
 *******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::vSetUserMute(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("vSetUserMute()ubOnOff=%u",(tU8) ubOnOff));
  ETG_TRACE_USR4(("vSetUserMute() empty function !!!!!!!!!!!!! "));

  /*if(ubOnOff == 1)
  {
    StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_MUTE;
    m_pUserMute->muteStream(userMuteRegId, action , EN_AUDIO_FADING_RES_USR,EN_AUDIO_SOURCE_STREAM_MAIN);
  }
  else
  {
    StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_DEMUTE;
    m_pUserMute->muteStream(userMuteRegId, action , EN_AUDIO_FADING_RES_USR,EN_AUDIO_SOURCE_STREAM_MAIN);
  }*/

}

/********************************************************************************
 * StreamMuteNotify()
 *******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink)
{

  ETG_TRACE_USR4(("StreamMuteNotify()muteAck=%u,stream = %u, sink %d",(tU8) muteAck, stream,sink));

  tenMuteResult muteResult = EN_AUDIO_MUTE_MUTERESULT_MUTE;
  switch(muteAck)
  {
  case MUTE_ACK_DEMUTE:
    muteResult = EN_AUDIO_MUTE_MUTERESULT_DEMUTE;
    break;
  case MUTE_ACK_DEMUTE_RUNNING:
    muteResult = EN_AUDIO_MUTE_MUTERESULT_DEMUTE_RUNNING;
    break;
  default:
    break;
  }
  ETG_TRACE_USR4(("StreamMuteNotify()muteResult=%u",(tU8) muteResult));
}

/********************************************************************************
 * SetSoundConfig()
 *******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::SetSoundConfig(tU8 ubSoundConfig)
{
  ETG_TRACE_USR4(("SetSoundConfig ubSoundConfig = %u",(tU8) ubSoundConfig));

  aud_ubExtBooster = ubSoundConfig;
}

/******************************************************************************/
/*  vCheckAccStatus()                                                                */
/******************************************************************************/
void aud_sinkmgr_pwramp_AIVI::vCheckAccStatus()
{
   tenAccState enNewAccStatus = enGetAccStatus();

   ETG_TRACE_USR2(("vCheckAccStatus(): ACC Status   %u -> %u", m_enLastAccStatus, enNewAccStatus))

   if (m_enLastAccStatus != enNewAccStatus)
   {
      m_enLastAccStatus = enNewAccStatus;

      /* if(enNewAccStatus == AUD_SINKMGR_ACC_OFF)
      {
         //set and check special mute
         fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_SPECIAL_MUTE);
      } */

      vCheckPwrAmp();
   }
}

/******************************************************************************/
/*  enGetAccStatus()                                                                */
/*  RETURNVALUE: Status of the pin                                            */
/******************************************************************************/
aud_sinkmgr_pwramp_AIVI::tenAccState aud_sinkmgr_pwramp_AIVI::enGetAccStatus(void)
{
   DEV_WUP_trOnOffStates rOnOffStates;
   rOnOffStates.u16MsgHandle = 0; // uselesss init parameter, just to suppress LINT Warning 530: Symbol not initialized
   tS32 success = OSAL_s32IOControl(m_hDevWup, OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_STATES, ( intptr_t ) &rOnOffStates);
   if (OSAL_ERROR == success)
   {
      ETG_TRACE_FATAL( ( "OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_STATES IOctrl Failed" ) )
      return AUD_SINKMGR_ACC_UNKNOWN;
   }

   tU32 S_Contact = rOnOffStates.uOnOffStates.rBitfield.S_CONTACT;
   ETG_TRACE_USR3(("enGetAccStatus(): ACC state = %u", S_Contact))
   if ( S_Contact)
      return AUD_SINKMGR_ACC_ON;
   else // if ( S_Contact == 0 )
      return AUD_SINKMGR_ACC_OFF;
}

/******************************************************************************/
/*  vLaunchWupThread()                                                        */
/******************************************************************************/
void aud_sinkmgr_pwramp_AIVI:: vLaunchWupThread ()
{
   OSAL_trThreadAttribute rAttr;
   char sName[] = "AudWupTracker";
   rAttr.szName       = sName;
   rAttr.s32StackSize = 10000;
   rAttr.u32Priority  = OSAL_C_U32_THREAD_PRIORITY_NORMAL;
   rAttr.pfEntry      = (OSAL_tpfThreadEntry)vfnWupThread;
   rAttr.pvArg        = (void* ) this;

   m_hWupThreadId = OSAL_ThreadSpawn(&rAttr);
   if ( m_hWupThreadId == OSAL_ERROR )
      ETG_TRACE_FATAL(( "E R R O R : failed launching Wup thread" ))
   else
      ETG_TRACE_USR3(( "successfully launched Wup thread" ))
}

/******************************************************************************/
/*  vShutdownWupThread()                                                        */
/******************************************************************************/
void aud_sinkmgr_pwramp_AIVI:: vShutdownWupThread ()
{
   ETG_TRACE_USR3(("vShutdownWupThread()"))

   // setup synchronization semaphore
   if (OSAL_OK != OSAL_s32SemaphoreCreate("WupShutdownSync", &m_hWupShutdownSync, 0))
      ETG_TRACE_FATAL(("vShutdownWupThread(): E R R O R - semaphore creation failed"))

   // trigger ACC monitoring thread for self-termination
   (void)OSAL_s32EventPost(m_hWupEvents, EVENT_MASK_STOP_WUP_THREAD, OSAL_EN_EVENTMASK_OR);

   // wait for thread termination confirmation
   if (OSAL_OK != OSAL_s32SemaphoreWait(m_hWupShutdownSync, 2000))
      ETG_TRACE_FATAL(("vShutdownWupThread(): E R R O R - semaphore wait failed"))

   // free semaphore
   (void)OSAL_s32SemaphoreClose(m_hWupShutdownSync);
   (void)OSAL_s32SemaphoreDelete("WupShutdownSync");
   m_hWupShutdownSync = OSAL_C_INVALID_HANDLE;
}

/******************************************************************************/
//  vfnWupThread (void *pvArg)
/******************************************************************************/
/* static */ void aud_sinkmgr_pwramp_AIVI:: vfnWupThread (void* pvArg)
{
   aud_sinkmgr_pwramp_AIVI* poThis = static_cast<aud_sinkmgr_pwramp_AIVI*>(pvArg);
   if (NULL == poThis)
   {
      ETG_TRACE_FATAL(("vfnWupThread() invoked with NULL"))
      return;
   }

   DEV_WUP_trClientRegistration  rClientRegistration;
   rClientRegistration.u32ClientId = 0; // not used
   if (OSAL_OK != OSAL_s32IOControl(poThis->m_hDevWup, OSAL_C_S32_IOCTRL_WUP_REGISTER_CLIENT, ( intptr_t ) &rClientRegistration))
   {
      ETG_TRACE_FATAL(( " E R R O R : failed registering to DEV_WUP" ))
      return;
   }
   else if (OSAL_OK != OSAL_s32EventOpen(rClientRegistration.szNotificationEventName, &poThis->m_hWupEvents))
   {
      ETG_TRACE_FATAL(( "E R R O R : failed opening events for DEV_WUP" ))
      return;
   }

   DEV_WUP_trOnOffReasonChangedRegistration rAccReg;
   rAccReg.u32ClientId        = rClientRegistration.u32ClientId;
   rAccReg.u8NotificationMode = DEV_WUP_C_U8_NOTIFY_STATES_ONLY;
   rAccReg.bIsSystemMaster    = FALSE;

   if (OSAL_OK == OSAL_s32IOControl(poThis->m_hDevWup, OSAL_C_S32_IOCTRL_WUP_REGISTER_ONOFF_REASON_CHANGED_NOTIFICATION, ( intptr_t ) &rAccReg))
   {
      ETG_TRACE_USR1(( "vfnWupThread() started ..."))

      for ( ; /* ever */; )
      {
         OSAL_tEventMask mask = DEV_WUP_C_U32_EVENT_MASK_ONOFF_STATE_CHANGED_NOTIFY | EVENT_MASK_STOP_WUP_THREAD;
         OSAL_tEventMask event = 0;

         // wait for state-change notification event from wake-up device
         (void) OSAL_s32EventWait(poThis->m_hWupEvents, mask, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &event);
         (void) OSAL_s32EventPost(poThis->m_hWupEvents, ~event, OSAL_EN_EVENTMASK_AND);

         ETG_TRACE_USR4( ( "vfnWupThread(): event %08x received", event))

         // delegate further processing to fc_audiomanager main thread
         if (event & DEV_WUP_C_U32_EVENT_MASK_ONOFF_STATE_CHANGED_NOTIFY)
            fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_CHECK_ACC);

         // check for termination event
         if (event & EVENT_MASK_STOP_WUP_THREAD)
            break;
      }

      ETG_TRACE_USR1( ( "vfnWupThread() terminating ..." ) );

      (void) OSAL_s32IOControl(poThis->m_hDevWup, OSAL_C_S32_IOCTRL_WUP_UNREGISTER_ONOFF_REASON_CHANGED_NOTIFICATION, (tS32)rAccReg.u32ClientId);
   }
   else
      ETG_TRACE_FATAL(( "vfnWupThread() registering failed."))

   (void)OSAL_s32IOControl(poThis->m_hDevWup, OSAL_C_S32_IOCTRL_WUP_UNREGISTER_CLIENT, (tS32)rClientRegistration.u32ClientId);

   // notify parent that we are done
   (void)OSAL_s32SemaphorePost(poThis->m_hWupShutdownSync);
}

/**
* Abstraction function to start different timers with timeout values based on the hardware.
*/

tVoid aud_sinkmgr_pwramp_AIVI::vStartTimer(tU16 uwTimerID)
{
  tBool bInternalAmplifierConfigured = ((aud_ubExtBooster == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1) || (aud_ubExtBooster == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2));

  tU16 uwTime= 0;

  tU8 ExtAmpConfig = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1;
  if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation", &ExtAmpConfig, 1))
  {
      ETG_TRACE_USR4(("OutputInformation : %d", ExtAmpConfig))
  }

  switch(uwTimerID)
  {
    case AUD_SINKMANAGER_TIMER_ID_DEMUTE:
    {
      if (bInternalAmplifierConfigured || EXTERNALAMP_BOSE2CH_MCAN == ExtAmpConfig || EXTERNALAMP_BOSE_5_1CH_MCAN == ExtAmpConfig)
      {
        uwTime = AUD_SINKMANAGER_TIMER_DEMUTE_NO_EXT_BOOSTER_INTERVAL;
      }
      else
      {
        //ANC Booster is being used
        if(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM5 == aud_ubExtBooster)
        {
          uwTime = AUD_SINKMANAGER_TIMER_DEMUTE_WITH_ANC_BOOSTER_INTERVAL;//1420 milli seconds
        }
        else if(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM3 == aud_ubExtBooster)
        {
          uwTime = AUD_SINKMANAGER_TIMER_WORKING_AUTHORIZE_ON_INTERVAL;//wait for 200ms
        }
        else//Bose booster is in use
        {
          uwTime = AUD_SINKMANAGER_TIMER_DEMUTE_WITH_BOSE_BOOSTER_INTERVAL;//2400 milliseconds
        }
      }
    }
    break;
    /* //Not handled
    case AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF:
      break;
    */
    case AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY:
    {
      uwTime = AUD_SINKMANAGER_TIMER_ADR3_STANDBY_INTERVAL;
      break;
    }
    case AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER:
    {
      if(bInternalAmplifierConfigured)
      {
        uwTime = AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_NO_EXT_BOOSTER;
      }
      else
      {
        if(m_bRecoveryFromLowVoltage)
        {
          uwTime = AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_WITH_EXT_BOOSTER_LOWVOLTAGE_RECOVERY;
        }
        else
        {
          uwTime = AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_WITH_EXT_BOOSTER;
        }
      }
      break;
    }
    default:
    {
      NORMAL_M_ASSERT_ALWAYS();
      return;
    }
  }

  ETG_TRACE_USR4(("aid_sinkmgr_pwramp_AIVI Timer Started with ID: %d, Timeout %d ms",uwTimerID,uwTime));
  //Start Timer
  aud_sinkmgr_timer::vStartTimer(uwTimerID,uwTime);

}

