/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_pwramp.h
 *
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _AUD_SINKMGR_PWRAMP_H_
#define _AUD_SINKMGR_PWRAMP_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/
#define AUD_SINK_DEMUTE 0
#define AUD_SINK_MUTE   1

/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/
#define AUD_SINK_STATE_OFF       0
#define AUD_SINK_STATE_ON_IP     1
#define AUD_SINK_STATE_ON        2
#define AUD_SINK_STATE_DEMUTE_IP 3
#define AUD_SINK_STATE_DEMUTED   4
#define AUD_SINK_STATE_MUTE_IP   5
#define AUD_SINK_STATE_MUTED     6
#define AUD_SINK_STATE_STANDBY   7

#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_main.h"
#include "fc_audiomanager_trace_macros.h"
#include "vd_adr3/vd_adr3Msg_If.h"
#include "vd_adr3/vd_adr3_If.h"
#include "vd_adr3/vd_adr3_thread.h"
#include "aud_sinkmgr_Gpio_If.h"
#include "aud_sinkmgr_main.h"
#include "aud_sinkmgr_timer.h"
#include "vd_adr3Msg_powerState.h"
#include "InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"
#include "InternalComponentCommunication/Messages/power/IDPowerState.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/PowerState.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/DiagControlLineType.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/power/ID_AudioState.h"
#include "InternalComponentCommunication/Messages/booster/IDSetBoosterState.h"
#include "../mute/stream/StreamMuteNotify_IF.h"
#include "../mute/stream/StreamMute_IF.h"

/******************************************************************************/
/* CLASS DEFINITIONS                                                           */
/******************************************************************************/
/* interface */ class aud_sinkmgr_pwramp
{
   protected:
      inline /* constructor */ aud_sinkmgr_pwramp ()  {}

   public:
      virtual /* inline destructor */ ~aud_sinkmgr_pwramp()  {}

  /**************************************************************************
   *  methods.
   **************************************************************************/
      virtual tVoid vInit() = 0;
      virtual tVoid vOnApplicationClose() = 0;
      virtual void vCheckAccStatus() = 0;
      virtual tVoid vCheckPwrAmp(tVoid) = 0;
      virtual tVoid vCheckPwrAmpTmr(tVoid) = 0;
      virtual tVoid vSetBoosterControl(tU8 ubOnOff) = 0;
      virtual void vSetSpecialMute(tU8 ubOnOff) = 0;
      virtual void vSetUserMute(tU8 ubOnOff) = 0;
      virtual tVoid vSetLowPowerFlag(tU8 ubOnOff) = 0;
      virtual tVoid vSetHighPowerFlag(tU8 ubOnOff) = 0;
      virtual tU8 ubGetLowPowerActiveFlag(tVoid) = 0;
      virtual void SetSoundConfig(tU8 ubSoundConfig) = 0;

      // factory function
      static aud_sinkmgr_pwramp* pCreateInstance(fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* m_pStreamMute);
};

class aud_sinkmgr_pwramp_PSA: public aud_sinkmgr_pwramp, public StreamMuteNotify_IF
{
public:
   tU8 muteRegId;
   tU8 userMuteRegId;

   aud_sinkmgr_pwramp_PSA();
   aud_sinkmgr_pwramp_PSA(fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* m_pStreamMute);
   ~aud_sinkmgr_pwramp_PSA(tVoid);

private:
   //  methods.
   tVoid vInit();
   tVoid vOnApplicationClose();
   void  vCheckAccStatus(void)  {  }  // dummy function
   tVoid vCheckPwrAmp(tVoid);
   tVoid vCheckPwrAmpTmr(tVoid);
   tVoid vSetBoosterControl(tU8 ubOnOff) { (tVoid)ubOnOff;};
   void vSetSpecialMute(tU8 ubOnOff);
   void vSetUserMute(tU8 ubOnOff);
   tVoid vSetLowPowerFlag(tU8 ubOnOff);
   tVoid vSetHighPowerFlag(tU8 ubOnOff);
   tU8 ubGetLowPowerActiveFlag(tVoid);
   void SetSoundConfig(tU8 ubSoundConfig);
   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);

   StreamMute_IF* m_pStreamMute;
   StreamMute_IF* m_pUserMute;
   fc_audiomanager_tclApp* m_poMainAppl;
   aud_sinkmgr_Gpio_If    *m_poAud_sinkmgr_Gpio_If;

   tVoid vMuteSink(tVoid);
   tVoid vDemuteSink(tVoid);

};

class aud_sinkmgr_pwramp_AIVI: public aud_sinkmgr_pwramp, public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   typedef enum
   {
      AUD_SINKMGR_ACC_OFF =0,
      AUD_SINKMGR_ACC_ON =1,
      AUD_SINKMGR_ACC_UNKNOWN
   } tenAccState;

   tU8 muteRegId;
   tU8 userMuteRegId;

   aud_sinkmgr_pwramp_AIVI();
   aud_sinkmgr_pwramp_AIVI(fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* m_pStreamMute);
   virtual ~aud_sinkmgr_pwramp_AIVI(tVoid);

private:
   //  methods.
   tVoid vInit();
   tVoid vOnApplicationClose();
   void vCheckAccStatus(void);
   tVoid vCheckPwrAmp(tVoid);
   tVoid vCheckPwrAmpTmr(tVoid);
   tVoid vSetBoosterControl(tBool ubOnOff);
   void vSetSpecialMute(tU8 ubOnOff);
   void vSetUserMute(tU8 ubOnOff);
   tVoid vSetLowPowerFlag(tU8 ubOnOff);
   tVoid vSetHighPowerFlag(tU8 ubOnOff);
   tU8 ubGetLowPowerActiveFlag(tVoid);
   void SetSoundConfig(tU8 ubSoundConfig);
   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);

   StreamMute_IF* m_pStreamMute;
   StreamMute_IF* m_pUserMute;
   fc_audiomanager_tclApp* m_poMainAppl;
   tenAccState m_enLastAccStatus;

   // track connection status of ACC power line through wake-up device DevWup
   OSAL_tIODescriptor m_hDevWup;
   OSAL_tEventHandle  m_hWupEvents;
   OSAL_tThreadID     m_hWupThreadId;
   OSAL_tSemHandle    m_hWupShutdownSync;
   tenAudioState m_enAudioState;
   tBool         m_bRecoveryFromLowVoltage;
   // query function
   tenAccState enGetAccStatus(void);
   // separate thread for monitoring
   void vLaunchWupThread ();
   void vShutdownWupThread ();
   static void vfnWupThread (void* pvArg);
   void vAddObserver();
   void MessageNotification(PO_MessageConfig::enID MsgId);
   InternalCommunicationAdapter* pPO; // Pointer for post office access

   tVoid vMuteSink(tVoid);
   tVoid vDemuteSink(tVoid);

   //Additional abstration function to handle timer start with specific timeouts
   tVoid vStartTimer(tU16 uwTimerID);
};


class aud_sinkmgr_pwramp_g3g : public aud_sinkmgr_pwramp, public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   aud_sinkmgr_pwramp_g3g();
   aud_sinkmgr_pwramp_g3g(fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* m_pStreamMute);
   ~aud_sinkmgr_pwramp_g3g(tVoid);

private:
   //  methods.
   tVoid vInit();
   tVoid vOnApplicationClose();
   tVoid vCheckAccStatus() {}; //No Implementation
   tVoid vCheckPwrAmp();
   tVoid vCheckPwrAmpTmr();
   tVoid vSetBoosterControl(tU8 ubOnOff) { (tVoid)ubOnOff;  }; //No Implementation
   tVoid vSetSpecialMute(tU8 ubOnOff);
   tVoid vSetUserMute(tU8 ubOnOff) {(tVoid)ubOnOff; };
   tVoid vSetLowPowerFlag(tU8 ubOnOff);
   tVoid vSetHighPowerFlag(tU8 ubOnOff);
   tU8 ubGetLowPowerActiveFlag();
   tVoid SetSoundConfig(tU8 ubSoundConfig);
   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);
   tU8 muteRegId;
   StreamMute_IF* m_pStreamMute;
   fc_audiomanager_tclApp* m_poMainAppl;
   tenAudioState m_enAudioState;
   tVoid vAddObserver();
   tVoid MessageNotification(PO_MessageConfig::enID MsgId);
   InternalCommunicationAdapter* pPO; // Pointer for post office access


   tVoid vMuteSink(tVoid);
   tVoid vDemuteSink(tVoid);
};

#endif //_AUD_SINKMGR_PWRAMP_H_

