/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_main.h
 *
 * SW-COMPONENT:  aud_sinkmgr application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _AUD_SINKMGR_MAIN_H_
#define _AUD_SINKMGR_MAIN_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

class StreamMute_IF;
class aud_sinkmgr_timer;
class vd_adr3_main;
class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;
class aud_sinkmgr_pwramp;
class aud_extampconn_timer;
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"

#include "vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "vd_amp_if/vd_amp_plugin_loader.h"

/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/

/******************************************************************************/
/* CLASS DEFINITION                                                           */
/******************************************************************************/

class aud_sinkmgr_main : public fc_audiomanager_tclTraceInput, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
    static aud_sinkmgr_main* m_poSinkMainInstance;

    aud_sinkmgr_pwramp* m_poSinkMgrPwramp;
    aud_sinkmgr_timer* m_poSinkMgrTimer;
    StreamMute_IF* m_poStreamMute;
  static vd_adr3_main* m_poVDAdr3Main;
  aud_extampconn_timer* m_poExtAmpConnTimer;

    aud_sinkmgr_main();
    aud_sinkmgr_main(fc_audiomanager_tclApp* poMainAppl);
    aud_sinkmgr_main(fc_audiomanager_tclApp* poMainAppl,fc_audiomanager_tclService_Audio_Function* poAudService);

    virtual ~aud_sinkmgr_main(tVoid);

    /**************************************************************************
     *  methods.
     **************************************************************************/
    tVoid vInit()const;
    static tVoid vOnApplicationClose();
    static aud_sinkmgr_pwramp* poGetPowerAmp();
    void vAddObserver();
    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    InternalCommunicationAdapter* pPO; // Pointer for post office access


    // inbox for TTFis
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);

    static tenApplicationStates ubGetApplicationState(tVoid);
    static void vUpdateProperty();
    static tBool bSendAdr3Status(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);

  tBool bLoadPlugins(tVoid);
  static plugin_loader* GetPluginLoaderInstance();
private:

  static tU8 m_BoseAmplifierConnectionStatus;

    static plugin_loader *m_po_pluginloader;
    static vd_amp_if_tx_rx *m_po_pluginreceiver;

    static fc_audiomanager_tclService_Audio_Function* m_AudioService;

};

#endif //_AUD_SINKMGR_MAIN_H_
