/*******************************************************************************
 *
 * FILE:          aud_extampconn_timer.h
 *
 * AUTHOR:      pmh7kor
 *
 * COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _AUD_EXTAMPCONN_TIMER_H_
#define _AUD_EXTAMPCONN_TIMER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#define AUD_SINKMANAGER_TIMER_ID_EXTAMPCONNECTION_CHECK 1

#define AUD_SINKMANAGER_TIMER_EXTAMPCONNECTION_INTERVAL                  30000 // Amplifier plugin should come up & update sound system config within 30sec

class aud_extampconn_timer : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:

  //static aud_extampconn_timer*   m_poAud_extampconn_timer;


  aud_extampconn_timer();
  virtual ~aud_extampconn_timer(tVoid);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  static tVoid vInit(tVoid);
  static tVoid vStartTimer(tU16 uwTimerID, tU16 uwTime);
  static tVoid vStopTimer(tU16 uwTimerID);

  static tVoid vExtAmpConnTimerCallback(tVoid* pArg);

  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    InternalCommunicationAdapter* pPO; // Pointer for post office access

  tVoid vSendDiagTurnOnStatus();
  bool bIsupdateRcvdfrmAmplifier();
  tVoid vChecknSendExtAmpDiagTurnStatus();
  tVoid vInitExtAmpParams();
private:
  tBool bIsExtAmplifierConnected();

  tU8 m_u8soundConfig;
  tU8 m_powerstate;
  static tBool m_bExtAmpTimerRunning;
  tU8 m_u8DiagRemoteControlPhase;

};

#endif
