/************************************************************************FA*
 *File         :  VolOffset_Manager.cpp
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  12/18/2012     Anu Sebastian
 ************************************************************************/

#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
// implicitly links generic <etrace_if.h> and <osal_if.h>

// some PO-message types
#include "../InternalComponentCommunication/Messages/Volume/IDSetVolumeOffset.h"
#include "../InternalComponentCommunication/Messages/VolumeOffset/IDVolumeOffsetAux.h"
#include "../InternalComponentCommunication/Messages/VolumeOffset/IDCCACueState.h"
#include "../InternalComponentCommunication/Messages/Source/IDCCAStartAudioSource.h"
#include "../InternalComponentCommunication/Messages/VolumeOffset/IDAudioPropertyOffset.h"
#include "../InternalComponentCommunication/Messages/ChildSleep/IDCCARearMute.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"

#include "VolOffset_Manager.h"
#include "AuxInVolumeOffset.h"
#include "CueVolumeOffset.h"
#include "SrcVolumeOffset.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "../util/Macro.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/VolOffset_Manager.cpp.trc.h"
#endif

#include "config/dp/AudioUserDpIfSelect.h"

enum eMuteAction
{
  AUDIO_MUTE_MUTEACTION_OFF = 0x00,
  AUDIO_MUTE_MUTEACTION_ON = 0x01,
  AUDIO_MUTE_MUTEACTION_UNDEF = 0xff
};

VolOffset_Manager::VolOffset_Manager(void):
IF_MessageObserver<PO_MessageConfig::enID>("VolumeOffset")
{
  poAuxInVolumeOffset = new AuxInVolOff();
  CenterMin_Value = 0;
  SubWooferMin_Value = 0;
  CenterMax_Value = 0;
  SubWooferMax_Value = 0;
    CenterGainPerStepValue = 0;
  SubWooferGainPerStepValue = 0;
  m_u8RearMute = 0xff;
  ChildSleep = false;
  VolOffset_Total = 0;
  InputGainOffset = 0;
  m_s16SubWoofer = 0;
  m_s16CenterGain = 0;
  AuxVal = 0;
  CCASource = 0;
  enSource = midw_fi_tcl_e8_AudSource::FI_EN_NONE;
  enAuxInLevel = EN_AUDIO_VOLOFFSET_AUXINLEVEL_LEVEL1;
  enCueType = EN_AUDIO_VOLOFFSET_CUETYPE_NOT_DEF;
  enStream = EN_AUDIO_SOURCE_STREAM_MAIN;
  ETG_TRACE_USR4(("VolOffset_Manager: AddingObservers"));
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);

  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_AudioSource);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AuxVolOffset);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCA_CueState);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AudioPropertyOffset);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_RearMute);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);

  ETG_TRACE_USR4(("VolOffset_Manager is added as observer for ID_SetSource and ID_AuxVolOffset"));
}

/* virtual */  VolOffset_Manager::~VolOffset_Manager()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  //delete(pPO);
  pPO = NULL;
  delete poAuxInVolumeOffset;
  poAuxInVolumeOffset = NULL;
}

void VolOffset_Manager::vOnLoadSettings()
{
  dp_tclAudioManagerDPAuxInLevel oAuxInLevel;
  tS32 s32Res = oAuxInLevel.s32GetData(AuxVal);
    enAuxInLevel = tenAuxInLevel(AuxVal);
  ETG_TRACE_USR4(("enAuxInLevel = %x",enAuxInLevel ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPCenter_Min oCenterMin;
  s32Res = oCenterMin.s32GetData(CenterMin_Value);
    ETG_TRACE_USR4(("CenterMin_Value = %x",CenterMin_Value ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPSubWoofer_Min oSubWooferMin;
   s32Res = oSubWooferMin.s32GetData(SubWooferMin_Value);
    ETG_TRACE_USR4(("SubWooferMin_Value = %x",SubWooferMin_Value ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPCenter_Max oCenterMax;
   s32Res = oCenterMax.s32GetData(CenterMax_Value);
    ETG_TRACE_USR4(("CenterMax_Value = %x",CenterMax_Value ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPSubWoofer_Max oSubWooferMax;
   s32Res = oSubWooferMax.s32GetData(SubWooferMax_Value);
    ETG_TRACE_USR4(("SubWooferMax_Value = %x",SubWooferMax_Value ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPCenter_GainPerStep oCenterGainPerStep;
   s32Res = oCenterGainPerStep.s32GetData(CenterGainPerStepValue);
    ETG_TRACE_USR4(("CanterGainPerStepValue = %x",CenterGainPerStepValue ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPSubWoofer_GainPerStep oSubWooferGainPerStep;
   s32Res = oSubWooferGainPerStep.s32GetData(SubWooferGainPerStepValue);
    ETG_TRACE_USR4(("SubWooferGainPerStepValue = %x",SubWooferGainPerStepValue ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  //RearMute
  dp_tclAudioManagerDPRearMute oRearMute;
    s32Res = oRearMute.s32GetData(m_u8RearMute);
    ETG_TRACE_USR4(("vOnLoadSettings() rear mute=%d",(tU8)m_u8RearMute));
  ID_CCAStart_RearMute startRearMute(m_u8RearMute);
  if((InternalCommunicationAdapter::getInstance()!=NULL) && (InternalCommunicationAdapter::getInstance()->POMessages!=NULL))
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startRearMute);
  vLoadVolumeOffsetDataFromDP();
  vCalcTotalVolumeOffset();
}

void VolOffset_Manager::MessageNotification(PO_MessageConfig::enID MsgId)
{
   ETG_TRACE_USR4(("VolOffset_Manager: Message Notification"));

   switch (MsgId)
   {
      case (PO_MessageConfig::ID_AuxVolOffset):
      {
         const MSG_VolumeOffsetAux* pMsgAuxVolOfset = pPO->POMessages->QueryMessage<MSG_VolumeOffsetAux>(MsgId);
         enAuxInLevel = pMsgAuxVolOfset->enAuxInLevel;
         break;
      }

      case (PO_MessageConfig::ID_CCAStart_AudioSource):
      {
         const ID_CCAStart_AudioSource* pMsgCCAStartAudioSource = pPO->POMessages->QueryMessage<ID_CCAStart_AudioSource>(MsgId);

         if(!vIsMixSource((midw_fi_tcl_e8_AudSource::tenType)pMsgCCAStartAudioSource->Source))
         {
         enSource = (midw_fi_tcl_e8_AudSource::tenType)pMsgCCAStartAudioSource->Source;
         }
         break;
      }

      case (PO_MessageConfig::ID_CCA_CueState):
      {
         const MSG_CueState* pMsgCueState = pPO->POMessages->QueryMessage<MSG_CueState>(MsgId);
         enCueType = pMsgCueState->encuestate;
         CCASource = pMsgCueState->ensource;
         break;
      }

      case (PO_MessageConfig::ID_AudioPropertyOffset):
      {
         const ID_AudioPropertyOffset* pMsgAudioProperty = pPO->POMessages->QueryMessage<ID_AudioPropertyOffset>(MsgId);
     ETG_TRACE_USR4(("VolOffset_Manager: Message Notification : ID_AudioPropertyOffset"));
     InputGainOffset = pMsgAudioProperty->OffSetValue;
     enSource = (midw_fi_tcl_e8_AudSource::tenType)pMsgAudioProperty->Source;
         break;
      }
      case PO_MessageConfig::ID_DiagDefSet:
      {
         // Obtaining the Diag DefSet
         const ID_DiagDefSet* pMsgDefSet = pPO->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
         ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));

         tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
         tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;

         if(enDefSetType == EN_DEFSET_HMI || enDefSetType == EN_USER_CHANGE || enDefSetType == EN_DEFSET_TEF)
         {
            if(enDefSetPhase == EN_DEFSET_FINISH)
            {
               ETG_TRACE_USR4(("DefSet HMI received EN_DEFSET_FINISH -> vOnLoadSettings()"));
               vOnLoadSettings();
            }
         }

         break;
      }
    case (PO_MessageConfig::ID_CCAStart_RearMute):
    {

     const ID_CCAStart_RearMute* pMsg = pPO->POMessages->QueryMessage < ID_CCAStart_RearMute > (MsgId);
     if((pMsg != NULL && AUDIO_MUTE_MUTEACTION_UNDEF != pMsg->RearMute) &&
       ((pMsg->RearMute == AUDIO_MUTE_MUTEACTION_ON) || (pMsg->RearMute == AUDIO_MUTE_MUTEACTION_OFF)))
     {
      m_u8RearMute = pMsg->RearMute;
      ETG_TRACE_USR2(("Rear_Mute: type =%d", m_u8RearMute));
      ChildSleep = (bool)m_u8RearMute;
      //notify clients
      NotifyRearMute(m_u8RearMute);
    }
     else
     {
        if(pMsg != NULL)
      ETG_TRACE_USR2(("Rear_Mute: type =%d , cannot be set", pMsg->RearMute));
     }
    break;
    }
      default:
      {
         break;
      }
   }

   vCalcTotalVolumeOffset();
}
void VolOffset_Manager::vAddInputGainOffSet(tS16 & VolOffset)
{
  ETG_TRACE_USR4(("VolOffset_Manager: vAddInputGainOffSet"));
  VolOffset = static_cast<tS16>(VolOffset + (tS16)InputGainOffset);
  ETG_TRACE_USR4(("VolOffset_Manager: VolOffset : %d", VolOffset));
  InputGainOffset = 0;
}

void VolOffset_Manager::vCalcTotalVolumeOffset()
{
    VolOffset_Total=0;
    if (poAuxInVolumeOffset)
       VolOffset_Total = static_cast<tS16>(VolOffset_Total + poAuxInVolumeOffset->GetVolOffset(enSource,enAuxInLevel));
    VolOffset_Total = static_cast<tS16>(VolOffset_Total + CueVolOff::GetVolOffset(CCASource,enCueType));
    VolOffset_Total = static_cast<tS16>(VolOffset_Total + SrcVolOff::GetVolOffset(enSource));
    vAddInputGainOffSet(VolOffset_Total);
    SetVolOffsetValue(VolOffset_Total);
}

void VolOffset_Manager::SetVolOffsetValue(tS16 VolOffset_Total_Set )
{
  VolumeOffsetData ADR3_VolOffset_Value;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
  ADR3_VolOffset_Value.s16Offset_CE = static_cast<tS16>(VolOffset_Total + (m_s16CenterGain * CenterGainPerStepValue * VOLOFFSET_RESOLUTION));
  ETG_TRACE_USR4(("Vol Offest_CE set to %d",ADR3_VolOffset_Value.s16Offset_CE));
#else
  ADR3_VolOffset_Value.s16Offset_CE = VolOffset_Total_Set;
#endif
  ADR3_VolOffset_Value.s16Offset_LF = VolOffset_Total_Set;
  ADR3_VolOffset_Value.s16Offset_LR = VolOffset_Total_Set;
  ADR3_VolOffset_Value.s16Offset_RF = VolOffset_Total_Set;
  ADR3_VolOffset_Value.s16Offset_RR = VolOffset_Total_Set;
  ETG_TRACE_USR2(("Rear_Mute: child sleep flag : %d", ChildSleep));
  if(ChildSleep)
  {
    ADR3_VolOffset_Value.s16Offset_RR = CHANNEL_MUTE;
    ADR3_VolOffset_Value.s16Offset_LR = CHANNEL_MUTE;
  }

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
  ADR3_VolOffset_Value.s16Offset_SUB = static_cast<tS16>(VolOffset_Total_Set + ( m_s16SubWoofer * SubWooferGainPerStepValue * VOLOFFSET_RESOLUTION));
  ETG_TRACE_USR4(("Vol Offest_SUB set to %d",ADR3_VolOffset_Value.s16Offset_SUB));
#else
  ADR3_VolOffset_Value.s16Offset_SUB = VolOffset_Total_Set;
#endif
  ADR3_VolOffset_Value.m_enStream = enStream;
  ADR3_VolOffset_Value.u16RampLin = 0x50 ;//Fast Mute
  ADR3_VolOffset_Value.u16RampdB  = 0x64;//Fast Mute

  ETG_TRACE_USR4(("The total volume offset value set= %x and the message is delivered to sink manager",VolOffset_Total));

  MSG_SetVolumeOffset oSetVolumeOfset(ADR3_VolOffset_Value);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSetVolumeOfset);
}
void VolOffset_Manager::vLoadVolumeOffsetDataFromDP()
{
  ETG_TRACE_USR4(("VolOffset_Manager:vLoadVolumeOffsetDataFromDP() entered"));

   if(AudioUserDpIfSelect::pGetAudUsrDpIf())
   {
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetCenterGain(m_s16CenterGain);
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetSubwoofer(m_s16SubWoofer);
   }

  ETG_TRACE_USR4(("vLoadVolumeOffsetDataFromDP():CenterGainDP=%d, SubWooferDP = %d", m_s16CenterGain, m_s16SubWoofer));
}

void VolOffset_Manager::vLimitCenterGain(void)
{
  if(m_s16CenterGain > CenterMax_Value)
  {
    m_s16CenterGain = CenterMax_Value;
  }

  else if(m_s16CenterGain < CenterMin_Value)
  {
    m_s16CenterGain = CenterMin_Value;
  }
}


void VolOffset_Manager::vLimitSubWooferGain(void)
{
  if(m_s16SubWoofer < SubWooferMin_Value )
  {
    m_s16SubWoofer = SubWooferMin_Value;
  }

  else if(m_s16SubWoofer > SubWooferMax_Value)
  {
    m_s16SubWoofer = SubWooferMax_Value;
  }

}

void VolOffset_Manager::vCalcCenterGain(fi_tclVisitorMessage& roMessage)
{
  ETG_TRACE_USR4(("VolOffset_Manager:vCalcCenterGain() entered"));
  midw_mascffi_tclMsgCenterSet oFiCenterGain;
  if (OSAL_ERROR != roMessage.s32GetData(oFiCenterGain))
  {
      if(AudioUserDpIfSelect::pGetAudUsrDpIf())
         AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetCenterGain(m_s16CenterGain);

    ETG_TRACE_USR4(("vCalcCenterGain():Resource=%d, CenterGain=%d", oFiCenterGain.Resource.enType, oFiCenterGain.Center));
    ETG_TRACE_USR4(("vCalcCenterGain():Sound Type = %d", oFiCenterGain.SoundType.enType));
    ETG_TRACE_USR4(("vCalcCenterGain():CenterGain stored in DP=%d", m_s16CenterGain));
    switch(oFiCenterGain.SoundType.enType)
    {
    case midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS:
      {
          m_s16CenterGain = oFiCenterGain.Center;
      }
      break;
    case midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC:
      {
          m_s16CenterGain = static_cast<tS16>(m_s16CenterGain + oFiCenterGain.Center);
      }
      break;
    case midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC:
      {
        m_s16CenterGain = static_cast<tS16>(m_s16CenterGain - oFiCenterGain.Center);
      }
      break;
    default:
      {
        ETG_TRACE_USR4(("vCalcCenterGain():undefined sound type for CenterGain"));
      }
      break;
    }

      vLimitCenterGain();

      if(AudioUserDpIfSelect::pGetAudUsrDpIf())
         AudioUserDpIfSelect::pGetAudUsrDpIf()->s32SetCenterGain(m_s16CenterGain);
  }
  else
  {
    ETG_TRACE_ERR(("vCalcCenterGain(): ERROR - could not read CenterSet message"));
  }
  ETG_TRACE_USR4(("vCalcCenterGain():CenterGain updated in DP=%d", m_s16CenterGain));
  vCalcTotalVolumeOffset();
  oFiCenterGain.vDestroy();
}

void VolOffset_Manager::vCalcSubWoofer(fi_tclVisitorMessage& roMessage)
{
  ETG_TRACE_USR4(("VolOffset_Manager:vCalcSubWoofer() entered"));
  midw_mascffi_tclMsgSubWooferSet oFiSubWoofer;

  if (OSAL_ERROR != roMessage.s32GetData(oFiSubWoofer))
  {
      if(AudioUserDpIfSelect::pGetAudUsrDpIf())
         AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetSubwoofer(m_s16SubWoofer);

    ETG_TRACE_USR4(("vCalcSubWoofer():Resource=%d, SubWoofer=%d", oFiSubWoofer.Resource.enType, oFiSubWoofer.SubWoofer));
    ETG_TRACE_USR4(("vCalcSubWoofer():Sound Type = %d", oFiSubWoofer.SoundType.enType));
    ETG_TRACE_USR4(("vCalcSubWoofer():SubWoofer stored in DP=%d", m_s16SubWoofer));
    switch(oFiSubWoofer.SoundType.enType)
    {
    case midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS:
      {
            m_s16SubWoofer = oFiSubWoofer.SubWoofer;
      }
      break;
    case midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC:
      {
        m_s16SubWoofer = static_cast<tS16>(m_s16SubWoofer + oFiSubWoofer.SubWoofer);
      }
      break;
    case midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC:
      {
        m_s16SubWoofer = static_cast<tS16>(m_s16SubWoofer - oFiSubWoofer.SubWoofer);
      }
      break;
    default:
      {
        ETG_TRACE_USR4(("vCalcSubWoofer():undefined sound type for SubWoofer"));
      }
      break;
    }

      vLimitSubWooferGain();

      if(AudioUserDpIfSelect::pGetAudUsrDpIf())
         AudioUserDpIfSelect::pGetAudUsrDpIf()->s32SetSubwoofer(m_s16SubWoofer);
  }
  else
  {
    ETG_TRACE_ERR(("vCalcSubWoofer(): ERROR - could not read SubWooferSet message"));
  }
  ETG_TRACE_USR4(("vCalcSubWoofer():SubWoofer updated in DP=%d", m_s16SubWoofer));
  vCalcTotalVolumeOffset();
  oFiSubWoofer.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION: VolOffset_Manager::NotifyRearMute(tU8 tRearMuteType)
 *
 * DESCRIPTION: Function called to notify new rearmute
 *
 * PARAMETER: tU8 tRearMuteType
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid VolOffset_Manager::NotifyRearMute(tU8 tRearMuteType)
{
    ETG_TRACE_USR4(("NotifyRearMute tRearMuteType:%d", tRearMuteType));
  //store persistent
  tS32 s32Res=0;
  dp_tclAudioManagerDPRearMute oRearMute;
  s32Res = oRearMute.s32SetData(m_u8RearMute);
  ETG_TRACE_USR4(("Persistent Memory storage Result for RearMute = %x and Result =%d",m_u8RearMute,s32Res));
}

/*******************************************************************************
 *
 * FUNCTION: VolOffset_Manager::vIsMixSource(midw_fi_tcl_e8_AudSource::tenType Source)
 *
 * DESCRIPTION: Function to check whether source is a mix source.
 *
 * PARAMETER: midw_fi_tcl_e8_AudSource::tenType Source.
 *
 * RETURNVALUE: bool.
 *
 *******************************************************************************/
bool VolOffset_Manager::vIsMixSource(midw_fi_tcl_e8_AudSource::tenType Source)
{
    switch(Source)
    {
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI:
      case midw_fi_tcl_e8_AudSource::FI_EN_SPI_MIX:
      case midw_fi_tcl_e8_AudSource::FI_EN_SPI_ML_INFO:
      case midw_fi_tcl_e8_AudSource::FI_EN_IPA_TTS:
      case midw_fi_tcl_e8_AudSource::FI_EN_WEB_MIX:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_BY_SDS:
      case midw_fi_tcl_e8_AudSource::FI_EN_VPA_TTS:
      case midw_fi_tcl_e8_AudSource::FI_EN_AUTO_DRIVE:
      case midw_fi_tcl_e8_AudSource::FI_EN_DRVASS_VIDEO:

      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_HORIZON:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_HORIZON_RETRIGGER:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_XURGENT:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_XURGENT_RETRIGGER:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_ROUTE_AND_DEST_INFO:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_ROUTE_AND_DEST_INFO_RETRIGGER:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_EXTERNAL_TRIGGERED:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_EXTERNAL_TRIGGERED_RETRIGGER:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DEBUG:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DEBUG_RETRIGGER:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_SOUND:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_SOUND_RETRIGGER:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DRIVING_RECOMMENDATION:
      case midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DRIVING_RECOMMENDATION_RETRIGGER:

     return true;
      default:
     return false;
    }
}
