/************************************************************************FA*
 *File         :  SrcVolumeOffset.cpp
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  12/18/2012     Anu Sebastian
 ************************************************************************/



#include "SrcVolumeOffset.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/SrcVolumeOffset.cpp.trc.h"
#endif

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#define MAX_PAYLOAD 16

#include "../InternalComponentCommunication/DataTypes/TypeConverter/SourceTypeConverter.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/EDTypeDefines.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "../ExternItf/CCA/FI_Message/FI_Includes.h"

tS32 SrcVolOff::SourceOffsetVal = 0;

SrcVolOff::SrcVolOff()
{
  SourceOffsetVal = 0;
}

tS32 SrcVolOff::GetVolOffset(midw_fi_tcl_e8_AudSource::tenType Source)
{
  SourceTypeConverter* pSourceConverter = SourceTypeConverter::getInstance();
  tU8 EDtype = EN_ED_NO_GAIN;

  dp_tclAudioManagerDPEngineeringData oDPEngineeringData;

  tS32 *s32EngineeringData = OSAL_NEW tS32[MAX_PAYLOAD];
  if(s32EngineeringData != OSAL_NULL)
  {
   oDPEngineeringData.s32GetData(s32EngineeringData,MAX_PAYLOAD);
    if(pSourceConverter != OSAL_NULL)
    {
    EDtype = (tU8)pSourceConverter->getEdType(Source);
    ETG_TRACE_USR4(("EDTYpe : %d",EDtype));
    }

      if(EDtype != (tU8) EN_ED_NO_GAIN)
      {
     SourceOffsetVal = (tS16)s32EngineeringData[EDtype];
     ETG_TRACE_USR4(("SourceOffsetVal : %d",SourceOffsetVal));
      }
     else
      {
      SourceOffsetVal = 0;
      }
  }
  OSAL_DELETE[] s32EngineeringData;

  ETG_TRACE_USR4(("SrcvolOffsetValue set to %x",SourceOffsetVal));

  return SourceOffsetVal;
}

