/************************************************************************FA*
 *File          :  AuxInVolumeOffset.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  12/17/2012    Anu Sebastian       Initial version
 ************************************************************************/

#ifndef AUXINVOLUMEOFFSET_H_
#define AUXINVOLUMEOFFSET_H_


#include "../fc_audiomanager_trace.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/VolOffset_AuxInLevel.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3SourceType.h"
#include "ExternItf/CCA/FI_Message/FI_Includes.h"

//Nissan LCN2kai level 1 'low' means low gain
#define VOLOFFSET_AUXIN_LEVEL1 0
#define VOLOFFSET_AUXIN_LEVEL2 2
#define VOLOFFSET_AUXIN_LEVEL3 10
#define VOLOFFSET_RESOLUTION  4

class AuxInVolOff
{
private:
    static const unsigned int AuxInValueCount = 3;
    tS16 AuxInLevelValues[AuxInValueCount];

    void vUpdateLevel(tU8 index, const char* pValue);

public:
     AuxInVolOff();
    ~AuxInVolOff()
    {}

    tS16 GetVolOffset(midw_fi_tcl_e8_AudSource::tenType enSourceType,tS16 AuxInLevel);

};


#endif /* AUXINVOLUMEOFFSET_H_ */
