/************************************************************************FA*
 *File         :  AuxInVolumeOffset.cpp
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  12/17/2012     Anu Sebastian
 ************************************************************************/
#include "AuxInVolumeOffset.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/AuxInVolumeOffset.cpp.trc.h"
#endif

#include <libxml/parser.h>
#include <libxml/xpath.h>


AuxInVolOff::AuxInVolOff()
{
  // initialize with default values
  AuxInLevelValues[0] = VOLOFFSET_RESOLUTION * VOLOFFSET_AUXIN_LEVEL1;
  AuxInLevelValues[1] = VOLOFFSET_RESOLUTION * VOLOFFSET_AUXIN_LEVEL2;
  AuxInLevelValues[2] = VOLOFFSET_RESOLUTION * VOLOFFSET_AUXIN_LEVEL3;

  // check if other values are provided in XML
  const char filename[] = "/var/opt/bosch/static/audio/audiomanager/AuxInLevel.xml";
  _xmlDoc* doc = xmlParseFile(filename);
  _xmlXPathContext* context = xmlXPathNewContext(doc);
  _xmlXPathObject* nodes = xmlXPathEvalExpression((const xmlChar*)"//AuxInLevel", context);

  if (nodes)
  {
     int cnt = xmlXPathNodeSetGetLength(nodes->nodesetval);

     ETG_TRACE_USR2(("AuxInVolOff(): Using XML configuration file \"%s\"", filename))

     for (int i = 0; i < cnt; ++i)
     {
        _xmlNode* n = nodes->nodesetval->nodeTab[i];
        const char* pName = (const char*)(xmlGetProp(n, (const xmlChar*)"name"));
        const char* pValue = (const char*)(xmlGetProp(n, (const xmlChar*)"value"));
        if (pName && pValue)
        {
           if (0 == strcmp(pName, "AUDIO_AUX_IN_LEVEL_1"))
              vUpdateLevel(0, pValue);
           else if (0 == strcmp(pName, "AUDIO_AUX_IN_LEVEL_2"))
              vUpdateLevel(1, pValue);
           else if (0 == strcmp(pName, "AUDIO_AUX_IN_LEVEL_3"))
              vUpdateLevel(2, pValue);
           else
              ETG_TRACE_ERR(("\t\tunexpected name \"%s\" found in XML", pName));
        }
     }
  }
  else if (doc)
  {
     ETG_TRACE_FATAL(("E R R O R - invalid XML configuration file \"%s\"", filename))
  }
  else
  {
     ETG_TRACE_USR2(("using default AuxInLevelValues: {%d/4 dB, %d/4 dB, %d/4 dB}"
           , AuxInLevelValues[0], AuxInLevelValues[1], AuxInLevelValues[2]))
  }

   xmlXPathFreeObject(nodes);
   xmlXPathFreeContext(context);
   xmlFreeDoc(doc);
   xmlCleanupParser();
}


void AuxInVolOff::vUpdateLevel(tU8 index, const char* pValue)
{
  // extract value from XML attribute, multiply by resolution and convert to nearest integer

  tS16 value = static_cast<tS16>(lrintf(VOLOFFSET_RESOLUTION * strtof(pValue, NULL)));
  AuxInLevelValues[index] = value;

  ETG_TRACE_USR2(("\t\tAuxInLevelValues[%u] = %d/4 dB", index, AuxInLevelValues[index]))
}


tS16 AuxInVolOff::GetVolOffset(midw_fi_tcl_e8_AudSource::tenType enSourceType,tS16 AuxInLevel)
{
   tS16 AuxInVolOffsetVal = AuxInLevelValues[0];
#if defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  if ((enSourceType == midw_fi_tcl_e8_AudSource::FI_EN_AUX))  {
#else
  if((enSourceType == midw_fi_tcl_e8_AudSource::FI_EN_AUX)||(enSourceType == midw_fi_tcl_e8_AudSource::FI_EN_AUX2)) {
#endif
    switch(AuxInLevel)
    {
      case EN_AUDIO_VOLOFFSET_AUXINLEVEL_LEVEL1:
        AuxInVolOffsetVal = AuxInLevelValues[0];
        break;
      case EN_AUDIO_VOLOFFSET_AUXINLEVEL_LEVEL2:
        AuxInVolOffsetVal = AuxInLevelValues[1];
        break;
      case EN_AUDIO_VOLOFFSET_AUXINLEVEL_LEVEL3:
        AuxInVolOffsetVal = AuxInLevelValues[2];
        break;
      default:
        break;
    }
}
  ETG_TRACE_USR3(("GetVolOffset() returns %d/4 dB for %u"
        , AuxInVolOffsetVal, ETG_CENUM(tenAuxInLevel, AuxInLevel)));

  return AuxInVolOffsetVal;
}


