//
// Types.h
//
// define special data types used in Volume management and not defiend elsewhere
//
//  Created on: Jun 25, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_9338D129_7260_4a03_8FF2_92A4407185BC__INCLUDED_)
#define EA_9338D129_7260_4a03_8FF2_92A4407185BC__INCLUDED_
//#ifndef TYPES_H_
//#define TYPES_H_

// reuse existing data types
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3DiagType.h"
//#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3SourceType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/VolumeModeDefines.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/VolumeLockTypes.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SPIMixModes.h"

// from Fading_IF.h
#include "InternalComponentCommunication/DataTypes/TypeDefines/Fading_Actions.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/Fading_Reason.h"


// import alltypes.h and alltoken.h from midw_fi
#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include <midw_fi_if.h>

#define MUTE -100
#define MultiUser 1

namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   enum tenResource
   {
      UndefinedResource
    , Speaker
    , Headphone
  , Sink3
  , Sink4
  , Sink5
  , Sink6
  , Sink17=17
   };

   // -----------------------------------------------------------------------------

   enum tenValueType
   {
      UndefinedChangeDirection
    , Absolute
    , Increment
    , Decrement
   };

   // -----------------------------------------------------------------------------

   struct Ramp
   {
      // defines the 2 components of volume ramps
      tU16 lin;
      tU16 dB;

      /* constructor */ Ramp(tU16 lin_, tU16 log_)
         : lin(lin_), dB(log_)  {  }
   };

   // -----------------------------------------------------------------------------

   enum tenFunctionType
   {
      enTAVolumeFilter = 1,
      enNavVolumeFilter,
      enBeepVolumeFilter,
      enDuckingFilter,
      enPDCAttenuator,
      enHeatProtector,
      enDiagVolume,
      enAttenuationFilter
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager



//#endif /* TYPES_H_ */
#endif // !defined(EA_9338D129_7260_4a03_8FF2_92A4407185BC__INCLUDED_)
