//
// TypeConversions/MappingData.cpp
//
// provides mapping tables for conversion functions from
//     - FI-types to internal types
//     - Amplifier-types to internal types
// and vice versa.
//
// uses the total template specialization technique described as Item 43
//    Effective C++, 55 Specific Ways to Improve Your Programs and Designs, 3rd Edition
//    Scott Meyers, Addison-Wesley, 2005
//
//  Created on: Jun 25, 2014
//      Author: Martin Koch, Fa. ESE.de
//


#include "Volume/Types.h" // implicitly links data types from <midw_fi_if.h>, <osal_if.h> and <stl_pif.h>
#include "Functions.h"



namespace VolumeManager
{

   // =============================================================================
   //
   //                        C o n v e r s i o n   D a t a
   //
   // -----------------------------------------------------------------------------
   //
   //                   FI-AudioChannel  <-->  internal StreamID

   template<>
   /* static */ const typename fiAudioChannel_StreamID_Map::Data fiAudioChannel_StreamID_Map :: data[]
    = {
         {midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF,  EN_AUDIO_SOURCE_STREAM_DEFAULT}
       , {midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC,   EN_AUDIO_SOURCE_STREAM_MAIN}
       , {midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX,   EN_AUDIO_SOURCE_STREAM_MIX1}
       , {midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX2,  EN_AUDIO_SOURCE_STREAM_MIX2}
       , {midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX3,  EN_AUDIO_SOURCE_STREAM_MIX3}
      };

   template<>
   /* static */ const size_t  fiAudioChannel_StreamID_Map::size
    = sizeof(fiAudioChannel_StreamID_Map::data) / sizeof(fiAudioChannel_StreamID_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                   FI - volume mode  <-->  internal volume mode

   template<>
   /* static */ const typename fiVolumeMode_Map::Data fiVolumeMode_Map :: data[]
    = {
         {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NOT_DEF, EN_INT_VOLMODE_NOT_DEF}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NORMAL, EN_INT_VOLMODE_NORMAL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_ONVOL, EN_INT_VOLMODE_SETUP_ONVOL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_TEL, EN_INT_VOLMODE_SETUP_TEL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_TIM, EN_INT_VOLMODE_SETUP_TIM}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_TA, EN_INT_VOLMODE_SETUP_TA}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_BEEPVOL, EN_INT_VOLMODE_SETUP_BEEPVOL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_DIAGVOL, EN_INT_VOLMODE_SETUP_DIAGVOL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NAV_ANNOUCEMENT, EN_INT_VOLMODE_NAV_ANNOUNCEMENT}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_NAV_VOL, EN_INT_VOLMODE_SETUP_NAV_VOL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL, EN_INT_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL}
       , {midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_PDC_ATTENUATION_VOL, EN_INT_VOLMODE_SETUP_PDC_ATTENUATION}
      };

   template<>
   /* static */ const size_t fiVolumeMode_Map::size
    = sizeof(fiVolumeMode_Map::data) / sizeof(fiVolumeMode_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                   FI - resource  <-->  internal resource

   template<>
   /* static */ const typename fiResource_Map::Data fiResource_Map :: data[]
    = {
         {midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_NOT_DEF, UndefinedResource}
       , {midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,  Speaker}
       , {midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP, Headphone}
       , {midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT, Sink17}
      };

   template<>
   /* static */ const size_t fiResource_Map::size
    = sizeof(fiResource_Map::data) / sizeof(fiResource_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                      FI - source  <-->  internal source

   template<>
   /* static */ const typename fiSource_Map::Data fiSource_Map :: data[]
    = {
         {midw_fi_tcl_e8_AudSource::FI_EN_NONE,     AUD_INT_SRC_NOSOURCE}
       , {midw_fi_tcl_e8_AudSource::FI_EN_FM,       AUD_INT_SRC_FM}
       , {midw_fi_tcl_e8_AudSource::FI_EN_FM_TA,    AUD_INT_SRC_FM_TA}
       , {midw_fi_tcl_e8_AudSource::FI_EN_AM,       AUD_INT_SRC_AM}
       , {midw_fi_tcl_e8_AudSource::FI_EN_DAB,      AUD_INT_SRC_DAB}
       , {midw_fi_tcl_e8_AudSource::FI_EN_DAB_TA,   AUD_INT_SRC_DAB_TA}
       , {midw_fi_tcl_e8_AudSource::FI_EN_XMTUN,    AUD_INT_SRC_XM}
       , {midw_fi_tcl_e8_AudSource::FI_EN_CPRA,     AUD_INT_SRC_CPRA}
       , {midw_fi_tcl_e8_AudSource::FI_EN_CDDA,     AUD_INT_SRC_CDDA}
       , {midw_fi_tcl_e8_AudSource::FI_EN_AUX,      AUD_INT_SRC_AUX}
       , {midw_fi_tcl_e8_AudSource::FI_EN_BT_AUDIO, AUD_INT_SRC_BT_AUDIO}
       , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_TTS,      AUD_INT_SRC_TTS}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE2,       AUD_INT_SRC_PHONE2}
       , {midw_fi_tcl_e8_AudSource::FI_EN_AUX2,         AUD_INT_SRC_AUX2}
       , {midw_fi_tcl_e8_AudSource::FI_EN_VRU,          AUD_INT_SRC_VRU}
       , {midw_fi_tcl_e8_AudSource::FI_EN_SMS,          AUD_INT_SRC_SMS}
       , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI,         AUD_INT_SRC_NAVI}
       , {midw_fi_tcl_e8_AudSource::FI_EN_CUE,          AUD_INT_SRC_CUE}
       , {midw_fi_tcl_e8_AudSource::FI_EN_CPRA2,        AUD_INT_SRC_CPRA2}
       , {midw_fi_tcl_e8_AudSource::FI_EN_IAPPS,        AUD_INT_SRC_IAPPS}
       , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_MAIN,     AUD_INT_SRC_SPI_MAIN}
       , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_PHONE,    AUD_INT_SRC_SPI_PHONE}
       , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR,       AUD_INT_SRC_SPI_VR}
       , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_MIX,      AUD_INT_SRC_SPI_MIX}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE_ANALOG_EXT, AUD_INT_SRC_PHONE_ANALOG_EXT}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE_ECALL,      AUD_INT_SRC_PHONE_ECALL}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE_OUTBAND_RING, AUD_INT_SRC_PHONE_OUTBAND_RING}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE_VR,           AUD_INT_SRC_PHONE_VR}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_1}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_2}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_3}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_4}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_5}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_6}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_7}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_8}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_9}
       , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE,      AUD_INT_SRC_PHONE_SET_10}
     , {midw_fi_tcl_e8_AudSource::FI_EN_TCU_ECALL,   AUD_INT_SRC_TCU_ECALL}
     , {midw_fi_tcl_e8_AudSource::FI_EN_TCU_SERVICECALL, AUD_INT_SRC_TCU_SERVICE_CALL}
     , {midw_fi_tcl_e8_AudSource::FI_EN_TCU_TTS,     AUD_INT_SRC_TCU_TTS}
     , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_ALERT,   AUD_INT_SRC_SPI_ALERT}
     , {midw_fi_tcl_e8_AudSource::FI_EN_DRM,      AUD_INT_SRC_DRM}
     , {midw_fi_tcl_e8_AudSource::FI_EN_PHONE_WAIT,  AUD_INT_SRC_PHONE_WAIT}
     , {midw_fi_tcl_e8_AudSource::FI_EN_BLU_RAY,    AUD_INT_SRC_BLU_RAY}
     , {midw_fi_tcl_e8_AudSource::FI_EN_EXTERNAL_CD,  AUD_INT_SRC_EXTERNAL_CD}
     , {midw_fi_tcl_e8_AudSource::FI_EN_AUX3,        AUD_INT_SRC_AUX3}
     , {midw_fi_tcl_e8_AudSource::FI_EN_MIC,      AUD_INT_SRC_MIC}
     , {midw_fi_tcl_e8_AudSource::FI_EN_SXM_NEWS,        AUD_INT_SRC_SXM_NEWS}
     , {midw_fi_tcl_e8_AudSource::FI_EN_IPA_TTS,        AUD_INT_SRC_IPA_TTS}
     , {midw_fi_tcl_e8_AudSource::FI_EN_DTV,          AUD_INT_SRC_DTV}
     , {midw_fi_tcl_e8_AudSource::FI_EN_MIC2,        AUD_INT_SRC_MIC2}
     , {midw_fi_tcl_e8_AudSource::FI_EN_AM_TI,            AUD_INT_SRC_AM_TI}
       , {midw_fi_tcl_e8_AudSource::FI_EN_WEB_ENT,          AUD_INT_SRC_WEB_ENT}
       , {midw_fi_tcl_e8_AudSource::FI_EN_WEB_INFO_USR,     AUD_INT_SRC_WEB_INFO_USR}
     , {midw_fi_tcl_e8_AudSource::FI_EN_SXM_TTS,          AUD_INT_SRC_SXM_TTS}
       , {midw_fi_tcl_e8_AudSource::FI_EN_WEB_INFO_SYSTEM,  AUD_INT_SRC_WEB_INFO_SYSTEM}
       , {midw_fi_tcl_e8_AudSource::FI_EN_WEB_MIX,           AUD_INT_SRC_WEB_MIX}
       , {midw_fi_tcl_e8_AudSource::FI_EN_WEB_TTS,           AUD_INT_SRC_WEB_TTS}
     ,{midw_fi_tcl_e8_AudSource::FI_EN_AUX2_DIAG,           AUD_INT_SRC_AUX2}
     , {midw_fi_tcl_e8_AudSource::FI_EN_VPA_MAIN,          AUD_INT_SRC_VPA_MAIN}
     , {midw_fi_tcl_e8_AudSource::FI_EN_VPA_SDS,       AUD_INT_SRC_VPA_SDS}
     , {midw_fi_tcl_e8_AudSource::FI_EN_VPA_TTS,       AUD_INT_SRC_VPA_TTS}
     , {midw_fi_tcl_e8_AudSource::FI_EN_RSE_IN,       AUD_INT_SRC_RSE_IN}
     , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_BY_SDS,     AUD_INT_SRC_NAVI_BY_SDS}
     , {midw_fi_tcl_e8_AudSource::FI_EN_USB_VIDEO,     AUD_INT_SRC_CPRA2}
     , {midw_fi_tcl_e8_AudSource::FI_EN_AUTO_DRIVE,           AUD_INT_SRC_AUTO_DRIVE}
       , {midw_fi_tcl_e8_AudSource::FI_EN_DRVASS_VIDEO,         AUD_INT_SRC_DRVASS_VIDEO}
     , {midw_fi_tcl_e8_AudSource::FI_EN_EXT_MEDIA1,           AUD_INT_SRC_EXT_MEDIA1}
     , {midw_fi_tcl_e8_AudSource::FI_EN_SPARE_CD,           AUD_INT_SRC_SPARE_CD}
     , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_ML_INFO,        AUD_INT_SRC_SPI_ML_INFO}
       , {midw_fi_tcl_e8_AudSource::FI_EN_ECO_TTS,            AUD_INT_SRC_ECO_TTS}
       , {midw_fi_tcl_e8_AudSource::FI_EN_EXT_NAVI,            AUD_INT_SRC_EXT_NAVI}
     , {midw_fi_tcl_e8_AudSource::FI_EN_WX,            AUD_INT_SRC_WX}
   , {midw_fi_tcl_e8_AudSource::FI_EN_INTERCOM,            AUD_INT_SRC_INTERCOM}
   , {midw_fi_tcl_e8_AudSource::FI_EN_WEB_SDS,       AUD_INT_SRC_WEB_SDS}
   , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR_STEREO, AUD_INT_SRC_SPI_VR_STEREO}
    , {midw_fi_tcl_e8_AudSource::FI_EN_MCS_AUDIO,    AUD_INT_SRC_MCS_AUDIO}
    , {midw_fi_tcl_e8_AudSource::FI_EN_MCS_VIDEO,    AUD_INT_SRC_MCS_VIDEO}


    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_HORIZON,                AUD_INT_SRC_NAVI_HORIZON }
    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_HORIZON_RETRIGGER,            AUD_INT_SRC_NAVI_HORIZON_RETRIGGER }
    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_XURGENT,                AUD_INT_SRC_NAVI_XURGENT }
    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_XURGENT_RETRIGGER,            AUD_INT_SRC_NAVI_XURGENT_RETRIGGER }
    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_ROUTE_AND_DEST_INFO,          AUD_INT_SRC_NAVI_ROUTE_AND_DEST_INFO }
    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_ROUTE_AND_DEST_INFO_RETRIGGER,    AUD_INT_SRC_NAVI_ROUTE_AND_DEST_INFO_RETRIGGER }
    , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_EXTERNAL_TRIGGERED,            AUD_INT_SRC_NAVI_EXTERNAL_TRIGGERED }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_EXTERNAL_TRIGGERED_RETRIGGER,    AUD_INT_SRC_NAVI_EXTERNAL_TRIGGERED_RETRIGGER }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DEBUG,                  AUD_INT_SRC_NAVI_DEBUG }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DEBUG_RETRIGGER,            AUD_INT_SRC_NAVI_DEBUG_RETRIGGER }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_SOUND,                  AUD_INT_SRC_NAVI_SOUND }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_SOUND_RETRIGGER,            AUD_INT_SRC_NAVI_SOUND_RETRIGGER }
  , {midw_fi_tcl_e8_AudSource::FI_EN_SDS_PROMPT,                  AUD_INT_SRC_SDS_PROMPT }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DRIVING_RECOMMENDATION,          AUD_INT_SRC_NAVI_DRIVING_RECOMMENDATION }
  , {midw_fi_tcl_e8_AudSource::FI_EN_NAVI_DRIVING_RECOMMENDATION_RETRIGGER,   AUD_INT_SRC_NAVI_DRIVING_RECOMMENDATION_RETRIGGER }
    , {midw_fi_tcl_e8_AudSource::FI_EN_HMI_SMS,                    AUD_INT_SRC_HMI_SMS }
  , {midw_fi_tcl_e8_AudSource::FI_EN_SXM_TTS_SPEECH,                AUD_INT_SRC_SXM_TTS_SPEECH }
  , {midw_fi_tcl_e8_AudSource::FI_EN_TTS_DEFAULT,                  AUD_INT_SRC_TTS_DEFAULT }
  , {midw_fi_tcl_e8_AudSource::FI_EN_SXM_IP,       AUD_INT_SRC_SXM_IP}
  , {midw_fi_tcl_e8_AudSource::FI_EN_WX_ALERT,       AUD_INT_SRC_WX_ALERT}



//     , {                                        ,           AUD_INT_SRC_CUE2}
//     , {                                        ,           AUD_INT_SRC_CUE3}
//     , {                                        ,           AUD_INT_SRC_CUE4}
//     , {                                        ,           AUD_INT_SRC_IPOD}
//     , {                                        ,           AUD_INT_SRC_DOV}
//     , {                                        ,           AUD_INT_SRC_PANDORA}
//     , {                                        ,           AUD_INT_SRC_DUMMY}  // it's currently used as a default source for strategy exit guard. Some strategies will only be left if this source is incoming.
//     , {                                        ,           AUD_INT_SRC_SPI_DUCK}
//     , {                                        ,           AUD_INT_SRC_SPI_UNDUCK}
//     , {                                        ,           AUD_INT_SRC_UNDEFINED}  // = 0xFF
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_RINGTONE}
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_1}
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_2}
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_3}
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_4}
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_5}
//     , {                                        ,           AUD_INT_SRC_PHONE_SET_6}
//     , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR_USB,                                }
//     , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR_BT_AUDIO,                           }
//     , {midw_fi_tcl_e8_AudSource::FI_EN_BT_AUDIO,                                  }
//     , {midw_fi_tcl_e8_AudSource::FI_EN_MIC,                                       }
//     , {midw_fi_tcl_e8_AudSource::FI_EN_SPI_USB,                                   }
      };

   template<>
   /* static */ const size_t fiSource_Map::size
    = sizeof(fiSource_Map::data) / sizeof(fiSource_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                     FI - Ext Amp Volume List

   template<>
   /* static */ const typename fiVolumeListExtAmpEntry_Map::Data fiVolumeListExtAmpEntry_Map :: data[]
    = {
         {EN_VOLTYPE_ENTERTAIN     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE1}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE2}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE3}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE4}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE5}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE6}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE7}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE8}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE9}
       , {EN_VOLTYPE_TELEPHONE     , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE10}
       , {EN_VOLTYPE_TELRINGTONE   , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_RINGTONE}
       , {EN_VOLTYPE_PHONECARPLAY  , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_CARPLAY_PHONE}
       , {EN_VOLTYPE_ALERTCARPLAY  , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SPI_ALERT}
       , {EN_VOLTYPE_ECALL         , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TCU_ECALL}
       , {EN_VOLTYPE_SERVICECALL   , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TCU_SERVICECALL}
       , {EN_VOLTYPE_TCUTTS        , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TCU_TTS}
       , {EN_VOLTYPE_SDS           , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SDS}
       , {EN_VOLTYPE_SPIINFO       , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SPI_INFO}
       , {EN_VOLTYPE_NAVIGATION    , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION}
       , {EN_VOLTYPE_DAN           , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP}
       , {EN_VOLTYPE_PARKASSIST    , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PARK_ASSIST}
       , {EN_VOLTYPE_OFFBOARDSDS   , midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SDS} //  EN_VOLTYPE_OFFBOARDSDS will be decided based on source in VolumeSetActionExtAmp

      };

   template<>
   /* static */ const size_t fiVolumeListExtAmpEntry_Map::size
    = sizeof(fiVolumeListExtAmpEntry_Map::data) / sizeof(fiVolumeListExtAmpEntry_Map::data[0]);

   // -----------------------------------------------------------------------------

   // -----------------------------------------------------------------------------
   //
   //                     FI - volume change direction

   template<>
   /* static */ const typename fiValueType_Map::Data fiValueType_Map :: data[]
    = {
         {midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_NOT_DEF  , UndefinedChangeDirection}
       , {midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS      , Absolute}
       , {midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC      , Increment}
       , {midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC      , Decrement}
      };

   template<>
   /* static */ const size_t fiValueType_Map::size
    = sizeof(fiValueType_Map::data) / sizeof(fiValueType_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                       FI - volume list entry

   template<>
   /* static */ const typename fiVolumeListEntry_Map::Data fiVolumeListEntry_Map :: data[]
    = {
         {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NOT_DEF,    255UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ONVOL,        0UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT,1UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE,        2UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE1,       3UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE2,       4UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE3,       5UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE4,       6UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE5,       7UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_RINGTONE,     8UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION,   9UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SDS,         10UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP,     11UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_VDA_PHONE,   12UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_BT_PHONE,    13UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_BEEP,        14UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SPI_INFO,    15UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE6,      16UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE7,      17UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE8,      18UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE9,      19UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE10,     20UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_CARPLAY_PHONE,   21UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TCU_ECALL,       22UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TCU_SERVICECALL, 23UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TCU_TTS,         24UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SPI_ALERT,       25UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ONVOL_SPI_INFO,  26UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_AUX3,           27UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE_WAIT,      28UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PARK_ASSIST,      29UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_SDS_BARGEIN,      30UL}
       , {midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_INTERCOM,         31UL}
      };

   template<>
   /* static */ const size_t fiVolumeListEntry_Map::size
    = sizeof(fiVolumeListEntry_Map::data) / sizeof(fiVolumeListEntry_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                       FI - volume-lock state

   template<>
   /* static */ const typename fiVolumeLockState_Map::Data fiVolumeLockState_Map :: data[]
    = {
         {midw_fi_tcl_e8_VolumeLock::FI_EN_AUDIO_VOLUME_LOCK_NOT_DEF, EN_INT_VOLUME_LOCK_MODE_UNDEF}
     , {midw_fi_tcl_e8_VolumeLock::FI_EN_AUDIO_VOLUME_LOCK_OFF, EN_INT_VOLUME_LOCK_MODE_OFF}
     , {midw_fi_tcl_e8_VolumeLock::FI_EN_AUDIO_VOLUME_LOCK_TOTAL, EN_INT_VOLUME_LOCK_MODE_TOTAL}
     , {midw_fi_tcl_e8_VolumeLock::FI_EN_AUDIO_VOLUME_LOCK_INCREASING, EN_INT_VOLUME_LOCK_MODE_INCREASING}
      };

   template<>
   /* static */ const size_t fiVolumeLockState_Map::size
    = sizeof(fiVolumeLockState_Map::data) / sizeof(fiVolumeLockState_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                       FI - volume-lock requester

   template<>
   /* static */ const typename fiVolumeLockRequester_Map::Data fiVolumeLockRequester_Map :: data[]
    = {
         {midw_fi_tcl_e8_Requester::FI_EN_UNKNOWN, EN_VOL_LOCK_REQUESTER_UNKNOWN}
     , {midw_fi_tcl_e8_Requester::FI_EN_HMI, EN_VOL_LOCK_REQUESTER_HMI}
     , {midw_fi_tcl_e8_Requester::FI_EN_AUDIOROUTINGMANAGER, EN_VOL_LOCK_REQUESTER_AUD_ROUTE_MGR}
     , {midw_fi_tcl_e8_Requester::FI_EN_TEMPERATUREHANDLER, EN_VOL_LOCK_REQUESTER_TEMP_HANDLER}
      };

   template<>
   /* static */ const size_t fiVolumeLockRequester_Map::size
    = sizeof(fiVolumeLockRequester_Map::data) / sizeof(fiVolumeLockRequester_Map::data[0]);

   // -----------------------------------------------------------------------------
   //
   //                       FI - amplifier thermal warning level

   template<>
   /* static */ const typename fiAmplifierWarningLevel_Map::Data fiAmplifierWarningLevel_Map :: data[]
    = {
         {midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_UNKNOWN, EN_AUDIO_DIAG_ERRVAL_UNDEF}
       , {midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_0, EN_AUDIO_DIAG_ERRVAL_NO_ERROR}
       , {midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_1, EN_AUDIO_DIAG_ERRVAL_SMALL}
       , {midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_2, EN_AUDIO_DIAG_ERRVAL_MID}
       , {midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_3, EN_AUDIO_DIAG_ERRVAL_HIGH}
//     , {                                                                , EN_AUDIO_DIAG_ERRVAL_ERROR}
//     , {                                                                , EN_AUDIO_DIAG_ERRVAL_CONDITION}
      };

   template<>
   /* static */ const size_t fiAmplifierWarningLevel_Map::size
    = sizeof(fiAmplifierWarningLevel_Map::data) / sizeof(fiAmplifierWarningLevel_Map::data[0]);

   // --------------------------------------------------------------------------

}   // namespace VolumeManager
