//
// VolumeManager/PropertyStore.h
//
// hold current values of all properties VolumeManager is responsible for
//
//  Created on: Jul 3, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_5D601FAF_A900_4ba4_B8EB_883F9BB33674__INCLUDED_)
#define EA_5D601FAF_A900_4ba4_B8EB_883F9BB33674__INCLUDED_
//#ifndef PROPERTYSTORE_H_
//#define PROPERTYSTORE_H_


class fi_tclMessageBase;
class fc_audiomanager_tclService_Audio_Function;

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#include <stl_pif.h>

#include <map>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
using namespace std;
#include "InternalComponentCommunication/MessageConfig.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "Volume/DatapoolTypes.h"
#include "Volume/Configuration/ConfigDetails.hpp"
namespace VolumeManager
{

#define DANLOWERLIMIT -5
#define DANUPPERLIMIT 10
   // --------------------------------------------------------------------------

   class  Configuration;
   class  SourceConfig;

   // --------------------------------------------------------------------------

   class PropertyStore  : private Uncopyable
   {
      struct Properties;
      typedef std::vector<tU16>  ChangeList;

   public:
      /* constructor */ PropertyStore(fc_audiomanager_tclService_Audio_Function& service);
      /* destructor */ ~PropertyStore();

      void vInitAll (const Configuration& config);
      void vLoadPersistentData ();
      void vCopyDatapoolValue(midw_fi_tcl_Aud_VolumeStatusList& List, tU16 _u16PoolId, tU16 _u16PoolSubId, tCString pcElementName);
      void vCopyValueListToBuffer(tVolumelistEntry* pBuf, const midw_fi_tcl_Aud_VolumeStatusList& lst, size_t& i,
    map<midw_fi_tcl_e8_Aud_VolumeType::tenType, VolumeConstraints>& PersistenceList);
      void vCopy_LimitDatapoolValue(midw_fi_tcl_Aud_VolumeStatusList& List, tU16 _u16PoolId, tU16 _u16PoolSubId, tCString pcElementName,const Configuration& config);
      void readKDSEntry(tU8 *);
      // reduce our data to basic FI message object to serve bStatusMessageFactory
      //  - provide sending parameters
      //  - provide serializing functionality
      const fi_tclMessageBase& rGetFIMessage (tU16 u16FunctionID);
      // trigger eUpdateClients for all properties which have changed so far
      void NotifyAllUpdates ();

      // support re-setting to factory defaults
      void vSetAllToDefaults (const Configuration& config);

      // Getters
      tU8 u8GetVolume () const;
      tU8 pGetResource () const;
      tS8 s8GetDanValue();
      bool bIsMix1Active () const;
      tS16 s16GetCANAttenuationLevel();
      tVoid vSetCANAttenuationLevel(tS16 dbLevel);
      tS16 s16GetADASAttenuationLevel();
      tVoid vSetADASAttenuationLevel(tS16 dbLevel);
      tVoid vSetMix1ActiveFlag();
      tVoid vSetSPIDuckingLevel(tS16);
      tS16 s16GetSPIDuckingLevel();
      tVoid vClearMix1ActiveFlag();
      bool bIsSPIDuckingActive () const;
      tVoid vSetSPIDuckingActiveFlag();
      tVoid vClearSPIDuckingActiveFlag();

      bool bIsCANAttenuationActive () const;
      tVoid vSetCANAttenuationFlag();
      tVoid vClearCANAttenuationFlag();

      bool bIsADASAttenuationActive () const;
      tVoid vSetADASAttenuationActiveFlag();
      tVoid vClearADASAttenuationActiveFlag();

      bool bIsTCUMuteRadioOrderActive () const;
      tVoid vSetTCUMuteRadioOrderActiveFlag();
      tVoid vClearTCUMuteRadioOrderActiveFlag();

      bool bIsExtAmpConnected () const;
      tVoid vSetExtAmpFlag();
      tVoid vClearExtAmpFlag();
      tVoid vUpdatePhonetype(tenInternalSource);
      tenInternalSource u8GetPhoneType();
      tVoid vSetDanValue(tS8 DAN);
      tVoid vResetDANValue();
      bool bIsVolumeInList(tenResource enResource, tU8 u8GroupTypeId) const;
      const tU8* pGetVolume (tenResource enResource, tU8 u8GroupTypeId) const;
      tenVolumeMode enGetMode (/* tenResource enResource */) const;
      tenVolumeLock enGetLockState () const;
      tU8 u8GetPDCAttenuationLevel () const;
      tenVolumeType enGetExtAmpVolumegroup(tU8 GroupID);
      midw_fi_tcl_e8_PDCAttenuation::tenType enGetPDCAttenuationStatus () const;

      // Updaters
      void vUpdateVolume (tenResource enResource, tenVolumeMode enMode, const SourceConfig& sourceConfig, tU8 volume);
      void vUpdateVolume (tenInternalSource Src, tenStream enStream, tU8 volume, tenVolumeType Volgrp);
      void vUpdateVolumeInList (tenResource enResource, tU8 u8GroupTypeId, tU8 volume);
      void vUpdateVolumeInList (const tU8* VolumeList);
      void vUpdateMode (tenVolumeMode enMode, tenStream enStream, tenResource enResource);
      void vUpdateLock (tenVolumeLockRequester enRequester, tenVolumeLock enNewLockState);
      void vUpdateOverTempAmplifierStatus (midw_fi_tcl_e8_AmpTemperatureLevel::tenType AmpTemperatureLevel);
      void vUpdateOverTempReduction (tBool ActiveByCommand, tBool ActiveByAmplifier, tU8 CurrentFactor, tU8 ReductionInterval);
      void vUpdatePDCAttenuationCommand (midw_fi_tcl_e8_PDCAttenuation::tenType enPDCCommand);
      void vUpdatePDCAttenuationLevel (tU8 u8Level);
      void vUpdateGala ();
      void vReloadData();
      void vSendVolumeListToPlugin();
      // keep track of current audio source
      void vSetCurrentSource (const SourceConfig& sourceConfig, tenResource enResource);
      tenInternalSource enGetCurrentSource ();
      void vCheckAndResetPhoneDeviceVolume(map<tU8, tBool>, const Configuration& config);
      bool bIsPhonegroup(midw_fi_tcl_e8_Aud_VolumeType::tenType VolType);
      midw_fi_tcl_Aud_VolumeStatusList& getLocalVolumeList();

   private:
      void vMarkAsChanged (tU16 u16FunctionID);
      void vStorePersistentData ();
      void vStoreLoudSpeakerPersistentData();
      void vStoreSink2PersistentData();

      // member variables
      fc_audiomanager_tclService_Audio_Function& _service;
      Properties* _pProperties;
      ChangeList* _pChangeList;
      tenInternalSource  _currentSource;
      tS8 m_s8Dan;
      bool              _bMix1ActiveFlag;
      bool              _SPIDuckingActiveFlag;
      tS16 m_s16SPIDuckingLevel;
      tenInternalSource _PhoneType;
      tS16 m_s16CANAttenuationLevel;
      tS16 m_s16ADASAttenuationLevel;
      bool              _CANAttenuationActiveFlag;
      bool              _ADASAttenuationActiveFlag;
      bool              _TCUMuteRadioOrderActiveFlag;
      bool              _bIsExtAmplifierConnected;

   };

   // --------------------------------------------------------------------------

}


//#endif /* PROPERTYSTORE_H_ */
#endif // !defined(EA_5D601FAF_A900_4ba4_B8EB_883F9BB33674__INCLUDED_)
