//
// VolumeManager/PropertyStore.cpp
//
// hold current values of all properties VolumeManager is responsible for
//
//  Created on: Jul 3, 2014
//      Author: Martin Koch, Fa. ESE
//



// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
//#include "osalio_public.h"

#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"



//Include public FI interface of this service.
//#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO

#include "./Types.h"  // implicitly links midw_fi alltypes.h and stl_pif.h vector
#include "Volume/Utilities/Uncopyable.h"
#include "./PropertyStore.h"
// - - - - - - - - - - - -

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/PropertyStore.cpp.trc.h"

#include "Volume/TypeConversions/Functions.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeStatusData.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_VolumeStatus.h"
#include "InternalComponentCommunication/DataTypes/TypeConverter/SourceTypeConverter.h"
#include "InternalComponentCommunication/Messages/Volume/ID_ExtAmpVolumeList.h"
#include "fc_audiomanager_service_Audio_Function.h"
#define RESERVED 5
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#define TARGET_VERSION 0x32  /* Upto now we make use only 001 version, this is for 002 */
#define DP_KDSLEN 7
#define KDS_KEY 0x010E
#include "fc_audiomanager_DpBinContainerElement.h"

// combined access identifiers for datapool element Volumes
#define DP_VOLUMES_IDENTIFIERS  (tU16)(DP_U32_POOL_ID_AUDIOMANAGERDP >> 16), (tU16)(DP_U32_POOL_ID_AUDIOMANAGERDP & 0xFFFF), "Volumes"
#define DP_VOLUMES_IDENTIFIERSUSR  (tU16)(DP_U32_POOL_ID_AUDIOMANAGERUSRDP >> 16), (tU16)(DP_U32_POOL_ID_AUDIOMANAGERUSRDP & 0xFFFF), "VolumesMulti"
#define DP_VOLUMES_IDENTIFIERS_SINK2  (tU16)(DP_U32_POOL_ID_AUDIOMANAGERDP >> 16), (tU16)(DP_U32_POOL_ID_AUDIOMANAGERDP & 0xFFFF), "Volumes_Sink2"

namespace VolumeManager
{

   // --------------------------------------------------------------------------

   struct PropertyStore:: Properties
   {
      midw_mascffi_tclMsgVolumeStatus              volumeMsg;
      midw_mascffi_tclMsgVolumeModeStatusStatus    modeMsg;
      midw_mascffi_tclMsgVolumeLockStatus          lockMsg;
      midw_mascffi_tclMsgVolumeListStatus          listMsg;
      midw_mascffi_tclMsgVolumeListStatus          listMsg2;
      midw_mascffi_tclMsgOverTempAmplifierStatusStatus ampMsg;
      midw_mascffi_tclMsgOverTempReductionStatus   reductMsg;
      midw_mascffi_tclMsgPDCAttenuationStatus      pdcAttMsg;
      midw_mascffi_tclMsgPDCAttenuationLevelStatus pdcLvlMsg;
      midw_mascffi_tclMsgGalaStatus                galaMsg;
      midw_mascffi_tclMsgLSValueStatusStatus       lsvalueMsg;

      // store also a list of all persistent volume groups
      typedef map<midw_fi_tcl_e8_Aud_VolumeType::tenType, VolumeConstraints>  PersistentsList;
      PersistentsList  persistents;
      typedef map<midw_fi_tcl_e8_Aud_VolumeType::tenType, VolumeConstraints>  PersistentsList_Multi;
      PersistentsList_Multi  persistents_Multi;

      // - - - - - - - - - - - - - - - - -

      /* destructor */ ~Properties()
      {
         try
         {
            volumeMsg.vDestroy();
            lockMsg.vDestroy();
            listMsg.vDestroy();
            listMsg2.vDestroy();
            modeMsg.vDestroy();
            ampMsg.vDestroy();
            reductMsg.vDestroy();
            pdcAttMsg.vDestroy();
            pdcLvlMsg.vDestroy();
            galaMsg.vDestroy();
            lsvalueMsg.vDestroy();
            persistents.clear();
         }
         catch (...)  { }
      }
   };

   // --------------------------------------------------------------------------

   // Default instance to be returned by rGetFIMessage() if no matching object can be found
   // (uniquely has TypeID EN_UNKNOWN)

   midw_mascffi_tclMsgBaseMessage unknownMsg;

   // ==========================================================================
   //
   //                        P r o p e r t y - S t o r e
   //

   /* constructor */ PropertyStore:: PropertyStore (fc_audiomanager_tclService_Audio_Function& service)
      : _service(service)
      , _pProperties(new Properties)
      , _pChangeList(new ChangeList)
      , _currentSource(AUD_INT_SRC_NOSOURCE)
      , m_s8Dan(0)
      , _bMix1ActiveFlag(false)
      , _SPIDuckingActiveFlag(false)
      , m_s16SPIDuckingLevel(MUTE)
      , _PhoneType(AUD_INT_SRC_PHONE_SET_1)
      , m_s16CANAttenuationLevel(MUTE)
      , m_s16ADASAttenuationLevel(MUTE)
      , _CANAttenuationActiveFlag(false)
      , _ADASAttenuationActiveFlag(false)
      , _TCUMuteRadioOrderActiveFlag(false)
  , _bIsExtAmplifierConnected(false)
   {
      if (NULL == _pProperties)
         ETG_TRACE_FATAL(("PropertyStore - E R R O R : Failed to create properties"))
      else if (NULL == _pChangeList)
         ETG_TRACE_FATAL(("PropertyStore - E R R O R : Failed to create change list"))
      else  // log
         ETG_TRACE_USR1(("PropertyStore established successfully"))
   }

   // --------------------------------------------------------------------------

   /* destructor */ PropertyStore:: ~PropertyStore ()
   {
      try  { delete _pProperties; }    catch (...)  { }
      try  { delete _pChangeList; }    catch (...)  { }
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vInitAll (const Configuration& config)
   {

      if (NULL ==_pProperties)
         return;

      // remove source information from volume message
      _pProperties->volumeMsg.Source.enType = midw_fi_tcl_e8_AudSource::FI_EN_NONE;

      // Set Mode to NORMAL
      _pProperties->modeMsg.VolumeMode.enType = midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NORMAL;

      // set Lock state to OFF, requester UNKNOWN is default
      _pProperties->lockMsg.VolumeLockType.enType = midw_fi_tcl_e8_VolumeLock::FI_EN_AUDIO_VOLUME_LOCK_OFF;

      // configure List from source config
      const GroupConfig* pConfig;
      size_t groupCount = 0;
      config.vGetSourceGroupConfigs(pConfig, groupCount);

      midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;
      midw_fi_tcl_Aud_VolumeStatusList& lstSink2 = _pProperties->listMsg2.AudVolumeList;

     //we can set the resource
      midw_fi_tcl_e8_ResourceNo& resourceSnk1 = _pProperties->listMsg.Resource;
      resourceSnk1.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

      midw_fi_tcl_e8_ResourceNo& resourceSnk2 = _pProperties->listMsg2.Resource;
      resourceSnk2.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;

      lst.VolumeStatusList.reserve(groupCount);
      for (unsigned i = 0; i < groupCount; ++i)
         {
            // add to list message
            lst.VolumeStatusList.push_back(midw_fi_tcl_Aud_VolumeStatus());
            midw_fi_tcl_Aud_VolumeStatus& entry = lst.VolumeStatusList.back();
            entry.AudVolumeType.enType = fiVolumeListEntry_Map::getFirst(pConfig[i].typeId);
            entry.Volume = pConfig[i].constraints.defaultStep;
  lstSink2.VolumeStatusList.push_back(midw_fi_tcl_Aud_VolumeStatus());
  midw_fi_tcl_Aud_VolumeStatus& entry2 = lstSink2.VolumeStatusList.back();
  entry2.AudVolumeType.enType = fiVolumeListEntry_Map::getFirst(pConfig[i].typeId);
  entry2.Volume = pConfig[i].constraints.defaultStep;

            if(pConfig[i].PersistanceType == MultiUser)
              {
        ETG_TRACE_USR1(("MultiUser DP : %d", entry.AudVolumeType.enType))
               _pProperties->persistents_Multi[entry.AudVolumeType.enType] = pConfig[i].persistenceConstraints;
               }
            else
              {
        ETG_TRACE_USR1(("Single User DP : %d", entry.AudVolumeType.enType))
            _pProperties->persistents[entry.AudVolumeType.enType] = pConfig[i].persistenceConstraints;

              }
            // for historical reasons, also support this:
            if (midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION == pConfig[i].typeId)
               _pProperties->lsvalueMsg.u8NaviSetupLs = pConfig[i].constraints.defaultStep;
         }

    ETG_TRACE_USR2(("Single User DP Size: %d", _pProperties->persistents.size()))
    ETG_TRACE_USR2(("Multi User DP Size: %d", _pProperties->persistents_Multi.size()))
      // Volume to default value for Entertainment
      for (unsigned i = 0; i < groupCount; ++i)
         if (pConfig[i].typeId == midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT)
         {
            _pProperties->volumeMsg.VolumeMode.enType   = midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NORMAL;
            _pProperties->volumeMsg.Channel.enType      = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
            _pProperties->volumeMsg.Resource.enType     = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
            _pProperties->volumeMsg.Volume              = pConfig[i].constraints.defaultStep;
            _pProperties->volumeMsg.Source.enType       = midw_fi_tcl_e8_AudSource::FI_EN_FM;
            //_currentSource = AUD_INT_SRC_FM;
         }

      // Over-Temperature Reduction
      _pProperties->reductMsg.CurrentFactor = 100;  // 100%
      _pProperties->ampMsg.AmpTemperatureLevel.enType = midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_0;
     
/* As we have new version of target 002 now */
      tU8 u8VariantInfo = 0x00;
      readKDSEntry(&u8VariantInfo);
      ETG_TRACE_USR2(("TARGET Version info: %x", u8VariantInfo))
      if(TARGET_VERSION == u8VariantInfo)
      {
          vCopy_LimitDatapoolValue(_pProperties->listMsg2.AudVolumeList, DP_VOLUMES_IDENTIFIERS_SINK2,config);
      } 

      ETG_TRACE_USR1(("PropertyStore::vInitAll() - initialization done."))
   }

void PropertyStore:: vCopy_LimitDatapoolValue(midw_fi_tcl_Aud_VolumeStatusList& lst, tU16 _u16PoolId, tU16 _u16PoolSubId, tCString pcElementName,const Configuration& config)
  {
      ETG_TRACE_USR1(("PropertyStore::vCopy_LimitDatapoolValue () Entered"))
      const StreamSetConfig* pConfigSet;
      tU8 pResource;
      tU8 pmax_limit;

      fc_audiomanager_tclDpBinContainerElement myDpElem(_u16PoolId, _u16PoolSubId, pcElementName);  //lint !e778 second argument always evaluates to 0 as long as low word of generated datapool constant is 0
      tS32 s32Status = myDpElem.s32GetStatus();
      if (DP_S32_NO_ERR != s32Status)
      {
         ETG_TRACE_ERR(("\t - E R R O R : Datapool error %u at element %s"
            , ETG_ENUM(enDataPoolError, s32Status), "Volumes"))
         return;
      }

      config.pGetStreamSet(pConfigSet);
      for (unsigned i = 0; i < config.getStreamSetCount(); ++i)
      {
         if (pConfigSet)
	     {
            if(Headphone == pConfigSet[i].enResource)
	        {
	            pmax_limit = pConfigSet[i].Startlimit.maxStep;
                ETG_TRACE_USR1(("PropertyStore::vCopy_LimitDatapoolValue pResources Headphone=%d enResource = %d Headphonepmax_limit = %d",Headphone,pConfigSet[i].enResource,pConfigSet[i].Startlimit.maxStep))
	        }
	      }
       }


      size_t dpSize = myDpElem.u32GetDataLength() / sizeof(tVolumelistEntry);
      const tVolumelistEntry* pDpEntry = reinterpret_cast<const tVolumelistEntry*>(myDpElem.pvGetData());

      for (size_t i = 0; i < dpSize; ++i)
      {
         midw_fi_tcl_e8_Aud_VolumeType::tenType enType
            = fiVolumeListEntry_Map::getFirst(pDpEntry[i].u8VolumeType);
         for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
         {
            if (enType == lst.VolumeStatusList[j].AudVolumeType.enType)
            {
               lst.VolumeStatusList[j].Volume = pDpEntry[i].u8Step;

	           if((lst.VolumeStatusList[j].Volume > pmax_limit) && (midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT != enType))
	           {
                   ETG_TRACE_USR2(("\t -  _Volume %u = %u"
                     , ETG_ENUM(T_e8_Aud_VolumeType, enType), lst.VolumeStatusList[j].Volume))
		           lst.VolumeStatusList[j].Volume = pmax_limit;
	            }
                // log
                ETG_TRACE_USR2(("\t - Headphone LIMIT Volume %u = %u"
                     , ETG_ENUM(T_e8_Aud_VolumeType, enType), lst.VolumeStatusList[j].Volume))
               break;  // found and updated, so continue with outer loop
              }
           }
        }
        vStoreSink2PersistentData();
  }

   // --------------------------------------------------------------------------

   void PropertyStore:: vLoadPersistentData ()
   {
      // update the VolumeList FI-object from datapool element content

      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vLoadPersistentData() - E R R O R : invalid pointer to Properties"))
         return;
      }

      ETG_TRACE_USR2(("vLoadPersistentData() - reading ..."))

      // PDC-Level
      {
         dp_tclAudioManagerDPPDCSetup_Volume dpPDCVolume;
         if (DP_S32_NO_ERR == dpPDCVolume.s32GetStatus())
         {
            _pProperties->pdcLvlMsg.PDCAttenuationLevel = dpPDCVolume.tGetData();
            ETG_TRACE_USR2(("\t - PDC attenuation-level = %u"
                  , _pProperties->pdcLvlMsg.PDCAttenuationLevel))
         }
         else
            ETG_TRACE_ERR(("\t - E R R O R : Datapool error %u at element %s"
                  , ETG_ENUM(enDataPoolError, dpPDCVolume.s32GetStatus()), "PDCVolume"))
      }

     if(_pProperties->persistents.size() != 0)
     {
  ETG_TRACE_USR2(("Reading LoudSpeaker Single User DP ..."))
  vCopyDatapoolValue(_pProperties->listMsg.AudVolumeList, DP_VOLUMES_IDENTIFIERS);
      }

    if(_pProperties->persistents_Multi.size() != 0)
      {
  ETG_TRACE_USR2(("Reading LoudSpeaker Multi User DP ..."))
  vCopyDatapoolValue(_pProperties->listMsg.AudVolumeList, DP_VOLUMES_IDENTIFIERSUSR);
      }
      ETG_TRACE_USR2(("Reading Sink2 (HeadPhones) DP ..."))
      vCopyDatapoolValue(_pProperties->listMsg2.AudVolumeList, DP_VOLUMES_IDENTIFIERS_SINK2);
  }
  void PropertyStore:: vCopyDatapoolValue(midw_fi_tcl_Aud_VolumeStatusList& lst, tU16 _u16PoolId, tU16 _u16PoolSubId, tCString pcElementName)
  {
      // open list datapool element
    fc_audiomanager_tclDpBinContainerElement myDpElem(_u16PoolId, _u16PoolSubId, pcElementName);  //lint !e778 second argument always evaluates to 0 as long as low word of generated datapool constant is 0
      tS32 s32Status = myDpElem.s32GetStatus();
      if (DP_S32_NO_ERR != s32Status)
      {
         ETG_TRACE_ERR(("\t - E R R O R : Datapool error %u at element %s"
            , ETG_ENUM(enDataPoolError, s32Status), "Volumes"))
         return;
      }

      size_t dpSize = myDpElem.u32GetDataLength() / sizeof(tVolumelistEntry);
      const tVolumelistEntry* pDpEntry = reinterpret_cast<const tVolumelistEntry*>(myDpElem.pvGetData());

      for (size_t i = 0; i < dpSize; ++i)
      {
         midw_fi_tcl_e8_Aud_VolumeType::tenType enType
            = fiVolumeListEntry_Map::getFirst(pDpEntry[i].u8VolumeType);
         for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
         {
            if (enType == lst.VolumeStatusList[j].AudVolumeType.enType)
            {
               lst.VolumeStatusList[j].Volume = pDpEntry[i].u8Step;
               // log
               ETG_TRACE_USR2(("\t - Volume %u = %u"
                     , ETG_ENUM(T_e8_Aud_VolumeType, enType), lst.VolumeStatusList[j].Volume))
               break;  // found and updated, so continue with outer loop
            }
         }

         if(midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT == enType)
           _pProperties->volumeMsg.Volume = pDpEntry[i].u8Step;

         // for historical reasons, also support this:
         if (midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION == enType)
            _pProperties->lsvalueMsg.u8NaviSetupLs = pDpEntry[i].u8Step;
      }
  }
  // --------------------------------------------------------------------------

   void PropertyStore:: vStorePersistentData ()
   {
      // copy the VolumeList FI-object to datapool element content

      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vStorePersistentData() - E R R O R : invalid pointer to Properties"))
        return;
      }

    vStoreLoudSpeakerPersistentData();
    vStoreSink2PersistentData();
  }
  // -----------------------------------------------------------------------------
  void PropertyStore:: vStoreLoudSpeakerPersistentData()
  {
    if(_pProperties->persistents.size() != 0)
      {
  // update datapool element
  tVolumelistEntry* paBbuffer = new tVolumelistEntry[_pProperties->persistents.size()];

  if (NULL == paBbuffer)
    {
      ETG_TRACE_FATAL(("vStorePersistentData() - failed to allocate buffer"))
            return;
    }

  // copy persistent list entries to buffer
  ETG_TRACE_USR2(("vStorePersistentData - storing volumes on LoudSpeaker Single User DP()"))
  size_t i = 0;
  vCopyValueListToBuffer(paBbuffer, _pProperties->listMsg.AudVolumeList, i, _pProperties->persistents);

  // write to data pool
  dp_tclAudioManagerDPVolumes myDpElem;
  tS32 s32Status = myDpElem.s32SetData (paBbuffer, (tU32)i);
      if (DP_S32_NO_ERR != s32Status)
         ETG_TRACE_ERR(("vStorePersistentData() - Datapool error %u at element %s"
            , ETG_ENUM(enDataPoolError, s32Status), "Volumes"))

      delete[] paBbuffer;
       }

     if(_pProperties->persistents_Multi.size() != 0)
       {

   tVolumelistEntry* paBbufferMulti = new tVolumelistEntry[_pProperties->persistents_Multi.size()];
   if (NULL == paBbufferMulti)
     {
       ETG_TRACE_FATAL(("vStorePersistentData() - failed to allocate buffer"))
             return;
    }

  size_t i = 0;

  vCopyValueListToBuffer(paBbufferMulti, _pProperties->listMsg.AudVolumeList, i, _pProperties->persistents_Multi);
  // copy persistent list entries to buffer
  ETG_TRACE_USR2(("vStorePersistentData - storing volumes on LoudSpeaker Multi User DP()"))

  // write to data pool
  dp_tclAudioManagerUsrDPVolumesMulti myDpElemMulti;
   tS32 s32Status = myDpElemMulti.s32SetData (paBbufferMulti, (tU32)i);
   if (DP_S32_NO_ERR != s32Status)
     ETG_TRACE_ERR(("vStorePersistentData() - Datapool error %u at element %s"
         , ETG_ENUM(enDataPoolError, s32Status), "VolumesMulti"))

   delete[] paBbufferMulti;
       }
   }

  // -----------------------------------------------------------------------------
  void PropertyStore:: vStoreSink2PersistentData()
  {
    // update datapool element
    tVolumelistEntry* paBbufferSink2 = new tVolumelistEntry[_pProperties->persistents.size()];

    if (NULL == paBbufferSink2)
      {
  ETG_TRACE_FATAL(("vStoreSink2PersistentData() - failed to allocate buffer"))
     return;
      }

    // copy persistent list entries to buffer
    ETG_TRACE_USR2(("vStoreSink2PersistentData - storing volumes on Sink2 Buffer"))
    size_t i = 0;

    vCopyValueListToBuffer(paBbufferSink2, _pProperties->listMsg2.AudVolumeList, i, _pProperties->persistents);
    // write to data pool
    dp_tclAudioManagerDPVolumes_Sink2 myDpElemSink2;
    tS32 s32Status = myDpElemSink2.s32SetData (paBbufferSink2, (tU32)i);
    if (DP_S32_NO_ERR != s32Status)
      ETG_TRACE_ERR(("vStoreSink2PersistentData() - Datapool error %u at element %s"
    , ETG_ENUM(enDataPoolError, s32Status), "Volumes_Sink2"))

    delete[] paBbufferSink2;
  }

  // -----------------------------------------------------------------------------
  void PropertyStore:: vCopyValueListToBuffer(tVolumelistEntry* pBuf, const midw_fi_tcl_Aud_VolumeStatusList& lst, size_t& i, map<midw_fi_tcl_e8_Aud_VolumeType::tenType, VolumeConstraints>& PersistenceList)
  {
    for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
      {
  midw_fi_tcl_e8_Aud_VolumeType::tenType enType = lst.VolumeStatusList[j].AudVolumeType.enType;
  PropertyStore:: Properties::PersistentsList_Multi::iterator itr = PersistenceList.find(enType);
  if (PersistenceList.end() != itr)
    {
      pBuf[i].u8VolumeType = enType;
      pBuf[i].u8Step = lst.VolumeStatusList[j].Volume;

      // limit to persistence constraints
      if (pBuf[i].u8Step > itr->second.maxStep)
        pBuf[i].u8Step = itr->second.maxStep;
      else if (pBuf[i].u8Step < itr->second.minStep)
        pBuf[i].u8Step = itr->second.minStep;
      ++i;
    }
      }
  }
  // --------------------------------------------------------------------------

   const fi_tclMessageBase& PropertyStore:: rGetFIMessage (tU16 u16FunctionID)
   {
      // reduce our data to basic FI message object to serve bStatusMessageFactory
      //  - provide sending parameters
      //  - provide serializing functionality

      if (NULL == _pProperties)
         return unknownMsg;

      switch (u16FunctionID)
      {
         case MIDW_MASCFFI_C_U16_VOLUME                  :  return _pProperties->volumeMsg;
         case MIDW_MASCFFI_C_U16_VOLUMELOCK              :  return _pProperties->lockMsg;
         case MIDW_MASCFFI_C_U16_VOLUMELIST              :  
         {
             tU16 enResource = _pProperties->volumeMsg.Resource.enType;
             ETG_TRACE_USR4(("rGetFIMessage Sink %d",enResource));
             if(Speaker == enResource)
                return _pProperties->listMsg;
             else if(Headphone == enResource)
                return _pProperties->listMsg2;
         }
         break;
         case MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS        :  return _pProperties->modeMsg;
         case MIDW_MASCFFI_C_U16_OVERTEMPAMPLIFIERSTATUS :  return _pProperties->ampMsg;
         case MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION       :  return _pProperties->reductMsg;
         case MIDW_MASCFFI_C_U16_PDCATTENUATION          :  return _pProperties->pdcAttMsg;
         case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL     :  return _pProperties->pdcLvlMsg;
         case MIDW_MASCFFI_C_U16_GALA                    :  return _pProperties->galaMsg;
         case MIDW_MASCFFI_C_U16_LSVALUESTATUS           :  return _pProperties->lsvalueMsg;
         default:
            return unknownMsg;
      }
   }

   // --------------------------------------------------------------------------

   tU8 PropertyStore:: u8GetVolume () const
   {
      if (NULL == _pProperties)
         return 0;

      return _pProperties->volumeMsg.Volume;
   }

   tU8 PropertyStore:: pGetResource () const
   {
      ETG_TRACE_USR1(("VMGR PropertyStore pGetResource"));
      if (NULL == _pProperties)
         return 0;

      ETG_TRACE_USR1(("VMGR PropertyStore pGetResource returning Resource %d",_pProperties->volumeMsg.Resource.enType));
      return _pProperties->volumeMsg.Resource.enType;
   }
   // --------------------------------------------------------------------------

   bool PropertyStore:: bIsVolumeInList (tenResource enResource, tU8 u8GroupTypeId) const
   {
      if (NULL == _pProperties)
         return false;

      if (Speaker == enResource)
      {
      const midw_fi_tcl_Aud_VolumeStatusList& lst =  _pProperties->listMsg.AudVolumeList;
         for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
            if (lst.VolumeStatusList[j].AudVolumeType.enType == u8GroupTypeId)
               return true;
      }
      else if(Headphone == enResource)
      {
     _pProperties->volumeMsg.Resource.enType     = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
      const midw_fi_tcl_Aud_VolumeStatusList& lst =  _pProperties->listMsg2.AudVolumeList;
         for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
            if (lst.VolumeStatusList[j].AudVolumeType.enType == u8GroupTypeId)
               return true;
      }

      // not found
      return false;
   }

   // --------------------------------------------------------------------------

   const tU8* PropertyStore:: pGetVolume (tenResource enResource, tU8 u8GroupTypeId) const
   {
      // lookup current, not necessarily active,  volume for given VolumeGroup

      if (NULL == _pProperties)
         return NULL;

     ETG_TRACE_USR3(("PropertyStore:: pGetVolume enResource =%d, u8GroupTypeId =%d",enResource, u8GroupTypeId));
    midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst(u8GroupTypeId);
    midw_fi_tcl_Aud_VolumeStatusList& lst =  _pProperties->listMsg.AudVolumeList;
    midw_fi_tcl_Aud_VolumeStatusList& lst2 =  _pProperties->listMsg2.AudVolumeList;
    if (Speaker == enResource)
      {
  ETG_TRACE_USR4(("Speakers"))
  for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
    if (lst.VolumeStatusList[j].AudVolumeType.enType == enType)
      return &(lst.VolumeStatusList[j].Volume);
      }
    else if (Headphone == enResource)
      {
   ETG_TRACE_USR4(("HeadPhones"))
  _pProperties->volumeMsg.Resource.enType     = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
  for (size_t j = 0; j < lst2.VolumeStatusList.size(); ++j)
    if (lst2.VolumeStatusList[j].AudVolumeType.enType == enType)
      return &(lst2.VolumeStatusList[j].Volume);
      }

    // not in list
    ETG_TRACE_FATAL(("u8GetVolume() - E R R O R :  could not serve volume type %u at resource %u"
         , ETG_CENUM(midw_fi_tcl_e8_Aud_VolumeType::tenType, enType)
         , ETG_CENUM(tenResource, enResource)))
      return NULL;
   }

   // --------------------------------------------------------------------------

   tenVolumeMode PropertyStore:: enGetMode (/* tenResource enResource */) const
   {
      if (_pProperties)
      {
//         if (Speaker == enResource)
            return fiVolumeMode_Map::getSecond(_pProperties->modeMsg.VolumeMode.enType);
//         else if (Headphone == enResource)
//            return EN_INT_VOLMODE_NOT_DEF;      //       t. b. d.   support Headphone
      }

      return EN_INT_VOLMODE_NOT_DEF;
   }

   // --------------------------------------------------------------------------

   tenVolumeLock PropertyStore:: enGetLockState () const
   {
      if (NULL == _pProperties)
         return EN_INT_VOLUME_LOCK_MODE_UNDEF;

      return fiVolumeLockState_Map::getSecond(_pProperties->lockMsg.VolumeLockType.enType);
   }

   // --------------------------------------------------------------------------

   tU8 PropertyStore:: u8GetPDCAttenuationLevel () const
   {
      if (NULL == _pProperties)
         return 0;

      return _pProperties->pdcLvlMsg.PDCAttenuationLevel;
   }

   // --------------------------------------------------------------------------

   midw_fi_tcl_e8_PDCAttenuation::tenType PropertyStore:: enGetPDCAttenuationStatus () const
   {
      if (NULL == _pProperties)
         return midw_fi_tcl_e8_PDCAttenuation::FI_EN_AUDIO_PDC_COMMAND_NOT_DEF;

    return _pProperties->pdcAttMsg.PDCAttenuation.enType;
  }

  // --------------------------------------------------------------------------

  void PropertyStore::vUpdateVolume (tenInternalSource Src, tenStream enStream, tU8 volume, tenVolumeType Volgrp)
  {
    if (NULL == _pProperties)
      {
  ETG_TRACE_ERR(("vUpdateVolume() -  E R R O R : invalid pointer to Properties"))
             return;
      }

    midw_mascffi_tclMsgVolumeStatus next;
    VolumeStatusData status;

    status.m_VolumeMode    = next.VolumeMode.enType   = midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NORMAL;
    status.m_Channel       = next.Channel.enType      = fiAudioChannel_StreamID_Map::getFirst(enStream);
    status.m_Resource      = next.Resource.enType     = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    status.m_Volume        = next.Volume              = volume;
    status.m_Source        = next.Source.enType       = fiSource_Map::getFirst(Src);

    midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;

    midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListExtAmpEntry_Map::getSecond(Volgrp);

  for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
    {
            if(enType == lst.VolumeStatusList[j].AudVolumeType.enType)
              {
          lst.VolumeStatusList[j].Volume = volume;
              }
    }
    // save to member and trigger client notification
    midw_mascffi_tclMsgVolumeStatus& current = _pProperties->volumeMsg;
    if ( ! (current == next))  // use comparison operator from FI catalog
      {
  current = next;  // use assignment operator from FI catalog
  vMarkAsChanged(current.u16GetFunctionID());

  // launch PO notification
  ID_CCA_VolumeStatus outMsg(status);
  InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
      }
    vStorePersistentData();
    NotifyAllUpdates();
  }
  // --------------------------------------------------------------------------

  void PropertyStore:: vUpdateVolume (tenResource enResource, tenVolumeMode enMode, const SourceConfig& sourceConfig, tU8 volume)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdateVolume() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      midw_mascffi_tclMsgVolumeStatus next;
      VolumeStatusData status;

      tenStream enStream = sourceConfig.enGetStreamID(enResource);
      status.m_VolumeMode    = next.VolumeMode.enType   = fiVolumeMode_Map::getFirst(enMode);
      status.m_Channel       = next.Channel.enType      = fiAudioChannel_StreamID_Map::getFirst(enStream);
      status.m_Resource      = next.Resource.enType     = fiResource_Map::getFirst(enResource);
      status.m_Volume        = next.Volume              = volume;
      status.m_Source        = next.Source.enType       = fiSource_Map::getFirst(sourceConfig.enGetSourceID());

      // save to member and trigger client notification
      midw_mascffi_tclMsgVolumeStatus& current = _pProperties->volumeMsg;
      if ( ! (current == next))  // use comparison operator from FI catalog
      {
         current = next;  // use assignment operator from FI catalog
         vMarkAsChanged(current.u16GetFunctionID());
         status.printData();

         // launch PO notification
         ID_CCA_VolumeStatus outMsg(status);
         InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
      }

   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vUpdateMode (tenVolumeMode enMode, tenStream enStream, tenResource enResource)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdateMode() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      // create local fi-object with new data
      midw_mascffi_tclMsgVolumeModeStatusStatus fiStatus;
      midw_fi_tcl_e8_VolumeMode::tenType enFIMode = fiVolumeMode_Map::getFirst(enMode);
      if (enFIMode == midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NOT_DEF)
         enFIMode = _pProperties->modeMsg.VolumeMode.enType;  // change only if FI catalog has valid entry
      fiStatus.VolumeMode.enType = enFIMode;
      fiStatus.Resource.enType = fiResource_Map::getFirst(enResource);   //      midw_fi_tcl_e8_ResourceNo Resource;
      fiStatus.Channel.enType = fiAudioChannel_StreamID_Map::getFirst(enStream);  //      midw_fi_tcl_e8_AudioChannel Channel;
//      fiStatus.Resource.enType = _pProperties->volumeMsg.Resource.enType;   //      midw_fi_tcl_e8_ResourceNo Resource;
//      fiStatus.Channel.enType = _pProperties->volumeMsg.Channel.enType;     //      midw_fi_tcl_e8_AudioChannel Channel;

      // update mode status
      if ( ! (fiStatus == _pProperties->modeMsg))
      {
         _pProperties->modeMsg = fiStatus;
         vMarkAsChanged(fiStatus.u16GetFunctionID());
      }

      // update also VolumeStatus
      if ( ! (_pProperties->volumeMsg.VolumeMode == fiStatus.VolumeMode))
      {
         _pProperties->volumeMsg.VolumeMode = fiStatus.VolumeMode;
         vMarkAsChanged(_pProperties->volumeMsg.u16GetFunctionID());
      }

      // free local object
      fiStatus.vDestroy();
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vUpdateLock (tenVolumeLockRequester enRequester, tenVolumeLock enNewLockState)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdateLock() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      // convert to mascf_fi enum values
      midw_fi_tcl_e8_VolumeLock::tenType fiLockType = fiVolumeLockState_Map::getFirst(enNewLockState);
      midw_fi_tcl_e8_Requester::tenType fiRequester = fiVolumeLockRequester_Map:: getFirst(enRequester);

      // make local reference to status message object
      midw_mascffi_tclMsgVolumeLockStatus& fiStatus = _pProperties->lockMsg;

      // compare against previous state
      bool hasChanged = (fiStatus.VolumeLockType.enType != fiLockType)
         || (fiStatus.Requester.enType != fiRequester);

      // update and prepare client notification
      if (hasChanged)
      {
         fiStatus.VolumeLockType.enType = fiLockType;
         fiStatus.Requester.enType = fiRequester;
         vMarkAsChanged(fiStatus.u16GetFunctionID());
      }
   }

   // --------------------------------------------------------------------------

  void PropertyStore:: vUpdateVolumeInList (tenResource  enResource, tU8 u8GroupTypeId, tU8 volume)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdateList() -  E R R O R : invalid pointer to Properties"))
         return;
      }

    if( Speaker == enResource)
      {
      midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst(u8GroupTypeId);
      midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;
      for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
         if (lst.VolumeStatusList[j].AudVolumeType.enType == enType)
         {
        if(bIsPhonegroup(enType))
    {
      lst.VolumeStatusList[j].Volume = volume;
      midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst( (tU8) midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE);
      for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
        if (lst.VolumeStatusList[j].AudVolumeType.enType == enType)
          {
      lst.VolumeStatusList[j].Volume = volume; // Update Generic Phone group to current connected Phone volume.
          }
    }
        vMarkAsChanged(_pProperties->listMsg.u16GetFunctionID());
               lst.VolumeStatusList[j].Volume = volume;
        break;
      }
      }
    else if(Headphone == enResource)
      {
  ETG_TRACE_USR2(("Updating  HeadPhones List"))
  _pProperties->volumeMsg.Resource.enType     = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_HP;
  midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst(u8GroupTypeId);
  midw_fi_tcl_Aud_VolumeStatusList& lstSink2 = _pProperties->listMsg2.AudVolumeList;
  for (size_t j = 0; j < lstSink2.VolumeStatusList.size(); ++j)
    if (lstSink2.VolumeStatusList[j].AudVolumeType.enType == enType)
      {
        if (lstSink2.VolumeStatusList[j].Volume != volume)
    {
      if(bIsPhonegroup(enType))
        {
          lstSink2.VolumeStatusList[j].Volume = volume;
          midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst( (tU8) midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE);
          for (size_t j = 0; j < lstSink2.VolumeStatusList.size(); ++j)
      if (lstSink2.VolumeStatusList[j].AudVolumeType.enType == enType)
        {
          lstSink2.VolumeStatusList[j].Volume = volume; // Update Generic Phone group to current connected Phone volume.
        }
        }
      vMarkAsChanged(_pProperties->listMsg2.u16GetFunctionID());
      lstSink2.VolumeStatusList[j].Volume = volume;
      ETG_TRACE_USR2(("Group : %d, Volume : %d", lstSink2.VolumeStatusList[j].AudVolumeType.enType, lstSink2.VolumeStatusList[j].Volume))
    }
        break;
      }
      }
    // update datapool element
    vStorePersistentData();

      // for historical reasons, also support this:
      if (midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_NAVIGATION == u8GroupTypeId)
      {
         _pProperties->lsvalueMsg.u8NaviSetupLs = volume;
         vMarkAsChanged(_pProperties->lsvalueMsg.u16GetFunctionID());
      }
  }

  // --------------------------------------------------------------------------
  void PropertyStore:: vUpdateVolumeInList (const tU8* VolumeList)
  {
    for(size_t i = 1 ; i < EN_VOLTYPE_MAX; i++)
      {
  midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;
  switch(i)
  {
    case RESERVED: //Reserved.. To be ignored for now.
      break;
    case (size_t)EN_VOLTYPE_DAN: // update DAN Volume
      {
        dp_tclAudioManagerUsrDPDAN_Multi dpDANVal;
        if (DP_S32_NO_ERR != dpDANVal.s32SetData(*VolumeList))
        ETG_TRACE_ERR(("Write Data() - E R R O R : Datapool error %u at element %s"
      , ETG_ENUM(enDataPoolError, dpDANVal.s32GetStatus()), "DAN_Multi"))

        VolumeList++;
      }
      break;
    case (size_t)EN_VOLTYPE_PARKASSIST: // update ParkAssistVolume
      {

        dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
        if (DP_S32_NO_ERR != odpParkAssitVol.s32SetData(*VolumeList))
        ETG_TRACE_ERR(("Write Data() - E R R O R : Datapool error %u at element %s"
      , ETG_ENUM(enDataPoolError, odpParkAssitVol.s32GetStatus()), "Adas_ParkAssitVol_Multi"))

        VolumeList++;
      }
      break;
    case (size_t)EN_VOLTYPE_LATERALASSIST: // update LateralAssistVolume
      {
        dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWVol;
        if (DP_S32_NO_ERR != odpLDWVol.s32SetData(*VolumeList))
        ETG_TRACE_ERR(("Write Data() - E R R O R : Datapool error %u at element %s"
      , ETG_ENUM(enDataPoolError, odpLDWVol.s32GetStatus()), "Adas_LDWUSerVol_Multi"))

        VolumeList++;
      }
      break;
    default:
      {
        midw_fi_tcl_e8_Aud_VolumeType::tenType enType =
      fiVolumeListExtAmpEntry_Map::getSecond((tenVolumeType)i);
        for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
    {
      if(enType == lst.VolumeStatusList[j].AudVolumeType.enType)
        {
          lst.VolumeStatusList[j].Volume = *VolumeList;
          VolumeList++;
          ETG_TRACE_USR2(("VolumeList : %d, Volume : %d", ETG_CENUM(midw_fi_tcl_e8_Aud_VolumeType::tenType, enType), lst.VolumeStatusList[j].Volume))
          break;
        }
    }
      }
      break;
  }
      }

    // update datapool element
    vStorePersistentData();
    vMarkAsChanged(_pProperties->listMsg.u16GetFunctionID());
    NotifyAllUpdates();

  }

  void PropertyStore:: vUpdateOverTempAmplifierStatus (midw_fi_tcl_e8_AmpTemperatureLevel::tenType AmpTemperatureLevel)
  {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdateOverTempAmplifierStatus() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      midw_mascffi_tclMsgOverTempAmplifierStatusStatus& msg = _pProperties->ampMsg;
      if (AmpTemperatureLevel == msg.AmpTemperatureLevel.enType)
         return;

      switch (AmpTemperatureLevel)
      {
         case midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_0:
         case midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_1:
         case midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_2:
         case midw_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_3:
            vMarkAsChanged(msg.u16GetFunctionID());
            msg.AmpTemperatureLevel.enType = AmpTemperatureLevel;
            return;

         default:  // ignore other values
            return;
      }
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vUpdateOverTempReduction (tBool ActiveByCommand, tBool ActiveByAmplifier, tU8 CurrentFactor, tU8 ReductionInterval)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdateOverTempReduction() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      midw_mascffi_tclMsgOverTempReductionStatus next;
      next.ActiveByCommand = ActiveByCommand;
      next.ActiveByAmplifier = ActiveByAmplifier;
      next.CurrentFactor = CurrentFactor;
      next.ReductionInterval = ReductionInterval;

      midw_mascffi_tclMsgOverTempReductionStatus& msg = _pProperties->reductMsg;
      if ( ! (next == msg))  // use comparison operator from FI catalog
      {
         msg = next;  // use assignment operator from FI catalog
         vMarkAsChanged(msg.u16GetFunctionID());
      }
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vUpdatePDCAttenuationCommand (midw_fi_tcl_e8_PDCAttenuation::tenType enPDCCommand)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdatePDCAttenuationCommand() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      midw_mascffi_tclMsgPDCAttenuationStatus& msg = _pProperties->pdcAttMsg;
      if (msg.PDCAttenuation.enType != enPDCCommand)
      {
         vMarkAsChanged(msg.u16GetFunctionID());
         msg.PDCAttenuation.enType = enPDCCommand;
      }
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vUpdatePDCAttenuationLevel (tU8 u8Level)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_ERR(("vUpdatePDCAttenuationLevel() -  E R R O R : invalid pointer to Properties"))
         return;
      }

      midw_mascffi_tclMsgPDCAttenuationLevelStatus& msg = _pProperties->pdcLvlMsg;
      if (msg.PDCAttenuationLevel != u8Level)
      {
         vMarkAsChanged(msg.u16GetFunctionID());
         msg.PDCAttenuationLevel = u8Level;

         // store PDC-Level persistently
         {
            ETG_TRACE_USR2(("vUpdatePDCAttenuationLevel() - storing PDC level ..."))
            dp_tclAudioManagerDPPDCSetup_Volume dpPDCLevel;
            if (DP_S32_NO_ERR != dpPDCLevel.s32SetData(u8Level))
               ETG_TRACE_ERR(("vLoadPersistentData() - E R R O R : Datapool error %u at element %s"
                     , ETG_ENUM(enDataPoolError, dpPDCLevel.s32GetStatus()), "PDCLevel"))
         }
      }
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vUpdateGala ()
   {

   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vMarkAsChanged (tU16 u16FunctionID)
   {
      // add FunctionId to change list

      if (NULL == _pChangeList)
         return;

      // determine, if given ID already is in list
      for (size_t i = 0; i < _pChangeList->size(); ++i)
         if ((*_pChangeList)[i] == u16FunctionID)
            return;

      // not in list, so append
      _pChangeList->push_back(u16FunctionID);
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: NotifyAllUpdates()
   {
      // trigger eUpdateClients for all properties which have changed so far

      if (NULL == _pChangeList)
         return;

      for (size_t i = 0; i < _pChangeList->size(); ++i)
         (void) _service.updateClients((*_pChangeList)[i]);

      _pChangeList->clear();
   }

   // --------------------------------------------------------------------------

   void PropertyStore:: vSetAllToDefaults (const Configuration& config)
   {
      if (NULL == _pProperties)
      {
         ETG_TRACE_FATAL(("vSetAllToDefaults() - E R R O R  : could not locate storage object"))
         return;
      }

      // establish fresh storage object on stack,
      // then use implicit (compiler-generated) assignment operator,
      // which delegates to assignment operators from FI catalog
      *_pProperties = Properties();

      _currentSource = AUD_INT_SRC_NOSOURCE;

      // do normal initialization
      vInitAll(config);
      vLoadPersistentData();

      // mark all as changed, so clients will be notified
      vMarkAsChanged(MIDW_MASCFFI_C_U16_VOLUME);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_VOLUMELOCK);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_VOLUMELIST);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_OVERTEMPAMPLIFIERSTATUS);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_PDCATTENUATION);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_GALA);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_LSVALUESTATUS);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP);
      vMarkAsChanged(MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP);

      // NotifyAllUpdates();  // shall be called externally !!!

      ETG_TRACE_USR1(("PropertyStore::vSetAllToDefaults() succeeded"))
  }

   // --------------------------------------------------------------------------

   void PropertyStore:: vSetCurrentSource (const SourceConfig& sourceConfig, tenResource enResource)
   {
      if (_currentSource == sourceConfig.enGetSourceID())
         return;   // nothing to do
      else if (NULL == _pProperties)
         return;

      // update Volume message also
      midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;
      tU8 u8SourceType = sourceConfig.u8GetGroupType();
      for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
         if (static_cast<tU8>(lst.VolumeStatusList[j].AudVolumeType.enType) == u8SourceType)
         {
            // make a local copy
            midw_mascffi_tclMsgVolumeStatus next = _pProperties->volumeMsg;
            next.Channel.enType      = fiAudioChannel_StreamID_Map::getFirst(sourceConfig.enGetStreamID(enResource));
            next.Resource.enType     = fiResource_Map::getFirst(enResource);
            next.Volume              = lst.VolumeStatusList[j].Volume;
            next.Source.enType       = fiSource_Map::getFirst(sourceConfig.enGetSourceID());

            // save to member and trigger client notification
            midw_mascffi_tclMsgVolumeStatus& current = _pProperties->volumeMsg;
            if ( ! (current == next))  // use comparison operator from FI catalog
            {
               current = next;  // use assignment operator from FI catalog
               vMarkAsChanged(current.u16GetFunctionID());
            }
            break;
         }
      _currentSource = sourceConfig.enGetSourceID();
   }

   // --------------------------------------------------------------------------

   tenInternalSource PropertyStore:: enGetCurrentSource()
   {
      return _currentSource;
   }
   // --------------------------------------------------------------------------
   tS8 PropertyStore::s8GetDanValue()
   {
     dp_tclAudioManagerUsrDPDAN_Multi dpDANVal;
     if (DP_S32_NO_ERR == dpDANVal.s32GetStatus())
       {
   m_s8Dan = dpDANVal.tGetData();
   ETG_TRACE_USR2(("\t - DAN Value Read from DP = %u", m_s8Dan))
       }
     else
       ETG_TRACE_ERR(("\t - E R R O R : Datapool error %u at element %s"
     , ETG_ENUM(enDataPoolError, dpDANVal.s32GetStatus()), "DAN_Multi"))
     return m_s8Dan;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetDanValue(tS8 DAN)
   {
     if(DAN < DANLOWERLIMIT)
     {
       m_s8Dan = DANLOWERLIMIT;
     }
     else if(DAN > DANUPPERLIMIT)
     {
       m_s8Dan = DANUPPERLIMIT;
     }
     else
     {
   m_s8Dan = DAN;
       }

     dp_tclAudioManagerUsrDPDAN_Multi dpDANVal;
     if (DP_S32_NO_ERR != dpDANVal.s32SetData(m_s8Dan))
        ETG_TRACE_ERR(("Write Data() - E R R O R : Datapool error %u at element %s"
              , ETG_ENUM(enDataPoolError, dpDANVal.s32GetStatus()), "DAN_Multi"))
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vResetDANValue()
   {
     m_s8Dan = 0;

   dp_tclAudioManagerUsrDPDAN_Multi dpDANVal;
     if (DP_S32_NO_ERR != dpDANVal.s32SetData(m_s8Dan))
        ETG_TRACE_ERR(("Write Data() - E R R O R : Datapool error %u at element %s"
              , ETG_ENUM(enDataPoolError, dpDANVal.s32GetStatus()), "DAN_Multi"))
   }
   // --------------------------------------------------------------------------
   bool PropertyStore::bIsMix1Active () const
   {
     return _bMix1ActiveFlag;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetMix1ActiveFlag()
   {
     _bMix1ActiveFlag = true;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vClearMix1ActiveFlag()
   {
     _bMix1ActiveFlag = false;
   }
   // --------------------------------------------------------------------------
   bool PropertyStore::bIsSPIDuckingActive () const
   {
     return _SPIDuckingActiveFlag;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetSPIDuckingActiveFlag()
   {
     _SPIDuckingActiveFlag = true;
   }
  // --------------------------------------------------------------------------
   tVoid PropertyStore::vClearSPIDuckingActiveFlag()
   {
     _SPIDuckingActiveFlag = false;
   }
  // --------------------------------------------------------------------------
   tVoid PropertyStore::vUpdatePhonetype(tenInternalSource type)
   {
     _PhoneType = type;
   }
   // --------------------------------------------------------------------------
   tenInternalSource PropertyStore::u8GetPhoneType()
   {
       return _PhoneType;
   }
   // --------------------------------------------------------------------------
   void PropertyStore::vReloadData()
   {
     vLoadPersistentData();

     // mark all as changed, so clients will be notified
     vMarkAsChanged(MIDW_MASCFFI_C_U16_VOLUME);
     vMarkAsChanged(MIDW_MASCFFI_C_U16_VOLUMELIST);

   }
   // --------------------------------------------------------------------------
   void PropertyStore::vCheckAndResetPhoneDeviceVolume(map<tU8, tBool> devicemap, const Configuration& config)
   {

    map<tU8, tBool>::iterator it = devicemap.begin();
     for(; it != devicemap.end(); it++)
       {
  if(!it->second) // If Phonetype value is False ie not paired, then reset it to default value.
    {
      SourceTypeConverter* pSourceConverter = SourceTypeConverter::getInstance();
       AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pSourceConverter);
       tenInternalSource Source = pSourceConverter->getIntSource((tenInternalPhoneTypes)it->first);

       // configure List from source config
       const GroupConfig* pConfig;
       size_t groupCount = 0;
       config.vGetSourceGroupConfigs(pConfig, groupCount);

       const SourceConfig* pSourceConfig = NULL;
       pSourceConfig = config.pGetSourceConfig(Source);

       if(pSourceConfig == NULL)
        continue;

       midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;
       for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
         {
     if (lst.VolumeStatusList[j].AudVolumeType.enType == pSourceConfig->u8GetGroupType())
       {
         lst.VolumeStatusList[j].Volume = pConfig[j].constraints.defaultStep;
       }
         }
     }
       }

       vStorePersistentData();
   }
  // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetSPIDuckingLevel(tS16 dbLevel)
   {
     m_s16SPIDuckingLevel = dbLevel;
   }
   // --------------------------------------------------------------------------
   tS16 PropertyStore::s16GetSPIDuckingLevel()
   {
     return m_s16SPIDuckingLevel;
   }
   // --------------------------------------------------------------------------
   tS16 PropertyStore::s16GetCANAttenuationLevel()
   {
      return m_s16CANAttenuationLevel;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetCANAttenuationLevel(tS16 dbLevel)
   {
     m_s16CANAttenuationLevel = dbLevel;
   }
   // --------------------------------------------------------------------------
   tS16 PropertyStore::s16GetADASAttenuationLevel()
   {
      return m_s16ADASAttenuationLevel;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetADASAttenuationLevel(tS16 dbLevel)
   {
      m_s16ADASAttenuationLevel = dbLevel;
   }
   // --------------------------------------------------------------------------
   bool PropertyStore::bIsCANAttenuationActive () const
   {
      return _CANAttenuationActiveFlag;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetCANAttenuationFlag()
   {
     _CANAttenuationActiveFlag = true;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vClearCANAttenuationFlag()
   {
     _CANAttenuationActiveFlag = false;
   }
   // --------------------------------------------------------------------------
   bool PropertyStore::bIsADASAttenuationActive () const
   {
     return _ADASAttenuationActiveFlag;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetADASAttenuationActiveFlag()
   {
     _ADASAttenuationActiveFlag = true;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vClearADASAttenuationActiveFlag()
   {
     _ADASAttenuationActiveFlag = false;
   }
   // --------------------------------------------------------------------------
   bool PropertyStore::bIsTCUMuteRadioOrderActive () const
   {
     return _TCUMuteRadioOrderActiveFlag;
   }
   // --------------------------------------------------------------------------
   tVoid PropertyStore::vSetTCUMuteRadioOrderActiveFlag()
   {
     _TCUMuteRadioOrderActiveFlag = true;
   }
   // --------------------------------------------------------------------------
  tVoid PropertyStore::vClearTCUMuteRadioOrderActiveFlag()
  {
    _TCUMuteRadioOrderActiveFlag = false;
  }
  // --------------------------------------------------------------------------
  bool PropertyStore::bIsExtAmpConnected () const
  {
     return _bIsExtAmplifierConnected;
  }
  // --------------------------------------------------------------------------
  tVoid PropertyStore::vSetExtAmpFlag()
  {
    _bIsExtAmplifierConnected = true;
  }
  // --------------------------------------------------------------------------
  tVoid PropertyStore::vClearExtAmpFlag()
  {
    _bIsExtAmplifierConnected = false;
  }
  // --------------------------------------------------------------------------
  bool PropertyStore::bIsPhonegroup(midw_fi_tcl_e8_Aud_VolumeType::tenType VolType)
  {
    switch(VolType)
    {
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE1:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE2:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE3:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE4:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE5:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE6:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE7:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE8:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE9:
      case midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE10:
  {
    return true;
  }
      default:
    return false;
    }
  }
  // --------------------------------------------------------------------------
  tenVolumeType PropertyStore::enGetExtAmpVolumegroup(tU8 GroupID)
  {
    midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst(GroupID);
    tenVolumeType volumeGroup = fiVolumeListExtAmpEntry_Map::getFirst(enType);
    return volumeGroup;
  }
  // --------------------------------------------------------------------------
  void PropertyStore::vSendVolumeListToPlugin()
  {
  map < tenVolumeType, tS8> CCAToAmpVolumeListValueMap;

    tS32 s32Res = 0;
    tU8 ParkAssistVol = 0;
    dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssistVol;
    s32Res = odpParkAssistVol.s32GetData(ParkAssistVol);
    ETG_TRACE_USR4((" s32Res: %d", s32Res));

    CCAToAmpVolumeListValueMap.insert(make_pair(EN_VOLTYPE_PARKASSIST,  ParkAssistVol));

    tU8 LDWUserVol = 0;
    dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;
    s32Res = odpLDWUserVol.s32GetData(LDWUserVol);

    CCAToAmpVolumeListValueMap.insert(make_pair(EN_VOLTYPE_LATERALASSIST,  LDWUserVol));

    CCAToAmpVolumeListValueMap.insert(make_pair(EN_VOLTYPE_DAN,  s8GetDanValue()));

    midw_fi_tcl_Aud_VolumeStatusList& lst = _pProperties->listMsg.AudVolumeList;
    for(size_t i = 1 ; i < 15; i++)
      {
  if(i == RESERVED)  // 5 is reserved in MCAN Spec
       continue;
     else
       {
         midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListExtAmpEntry_Map::getSecond((tenVolumeType)i);
         for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
           {
           if(enType == lst.VolumeStatusList[j].AudVolumeType.enType)
             {
               tS8 Value = (tS8)lst.VolumeStatusList[j].Volume;
               CCAToAmpVolumeListValueMap.insert(make_pair((tenVolumeType)i, Value));
        break;
             }
           }
       }
      }

    map< tenVolumeType, tS8>::const_iterator itr;

    for(itr = CCAToAmpVolumeListValueMap.begin(); itr != CCAToAmpVolumeListValueMap.end(); ++itr)
      ETG_TRACE_USR4((" Volumetype : %d, value : %d",ETG_ENUM(tenVolumeType, itr->first), (itr->second)))

      ID_ExtAmpVolumeList outMsg(CCAToAmpVolumeListValueMap);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&outMsg);
  }

  // --------------------------------------------------------------------------
  midw_fi_tcl_Aud_VolumeStatusList& PropertyStore::getLocalVolumeList()
  {
     return _pProperties->listMsg.AudVolumeList;
  }

/* Read HW_VERSION */
void PropertyStore::readKDSEntry(tU8 *hwversion)
{
   ETG_TRACE_USR4(("PropertyStore::readKDSEntry Entered"));
   OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS, OSAL_EN_READONLY);
   ETG_TRACE_USR4(("PropertyStore::readKDSEntry(%d)", tIoKdsHandle));
   if (OSAL_ERROR != tIoKdsHandle)
   {
      tsKDSEntry sKDSEntryData;

      sKDSEntryData.u16Entry = KDS_KEY;
      sKDSEntryData.u16EntryLength = DP_KDSLEN;
      sKDSEntryData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
      sKDSEntryData.au8EntryData[0] = 0;

      tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle, (tPS8)&sKDSEntryData, (sizeof(sKDSEntryData)));
      if (OSAL_ERROR != s32NbElements)
      {
          tU8 u8data[DP_KDSLEN] = {0, 0, 0, 0, 0, 0, 0};
          for (tU16 n=0; n < DP_KDSLEN; n++)
          {
                 u8data[n] = sKDSEntryData.au8EntryData[n];
		 *hwversion = u8data[2];
                 ETG_TRACE_USR4(( "[PropertyStore]:readKDSEntry: u8data[n] x = %x", u8data[n]));
          }

         ETG_TRACE_ERRMEM(("PropertyStore::readKDSEntry s32NbElements(%d)", s32NbElements));
      }
      else
      {
         ETG_TRACE_ERRMEM(("PropertyStore::readKDSEntry OSAL error while reading(%s)", OSAL_coszErrorText(OSAL_u32ErrorCode())));
      }
      (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
}

}  // namespace VolumeManager
