//
// VolumeManager/Configuration/Stream.h
//
//  Created on: Jun 26, 2014
//      Author: Martin Koch, Fa. ESE.de
//



#if !defined(EA_34A97FED_5A55_48c6_BC1A_D4C01470BEBE__INCLUDED_)
#define EA_34A97FED_5A55_48c6_BC1A_D4C01470BEBE__INCLUDED_
//#ifndef AUDIOSTREAM_H_
//#define AUDIOSTREAM_H_



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Source;
   class dBCalculator;
   struct StreamConfig;

   // -----------------------------------------------------------------------------

   class Stream  : private Uncopyable
   {
      private:
         const StreamConfig*  _pConfig;
         tenInternalSource _enCurrentSource;
         tenVolumeMode     _enCurrentMode;
         tenInternalSource _enRecentEntertainmentSource;
         tS16 _s16AttenuationdBLevel;
         bool _bCANAttenuationActive;

      public:
         /* constructor */ Stream (const StreamConfig& stream);
         /* default constructor */ Stream ();
         void swap (Stream& rhs);

         virtual /* destructor */ ~Stream ();

         inline tenInternalSource   enGetCurrentSource() const;
         inline tenInternalSource   enGetRecentEntertainmentSource ();
         inline tenVolumeMode       enGetCurrentMode();
         tenStream           enGetStreamID();
         tenResource         enGetResource();
         const char*       getName();
         tS16 s16GetStreamAttenuationLevel();
         void vSetStreamAttenuationlevel(tS16 Level);
         void vSetCANAttenuationActive();
         void vClearCANAttenuationActive();
         bool bIsCANAttenuationActiveOnStream();
         virtual void setVolume(const dBCalculator& calc, tU8 userStep, Ramp ramp);
         static bool isEntertainmentSource (tenInternalSource enSource);
         void vSetCurrentSource (tenInternalSource currentSource);
         inline void vSetCurrentMode (tenVolumeMode currentMode);
   };

   // -----------------------------------------------------------------------------

   inline tenInternalSource Stream:: enGetCurrentSource () const
         {  return _enCurrentSource;  }

   // -----------------------------------------------------------------------------

   inline tenInternalSource Stream:: enGetRecentEntertainmentSource ()
         {  return _enRecentEntertainmentSource; }

   // -----------------------------------------------------------------------------

   inline tenVolumeMode Stream:: enGetCurrentMode ()
         {  return _enCurrentMode;  }

   // -----------------------------------------------------------------------------

   inline void Stream:: vSetCurrentMode (tenVolumeMode currentMode)
         {  _enCurrentMode = currentMode;  }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


//#endif /* AUDIOSTREAM_H_ */
#endif // !defined(EA_34A97FED_5A55_48c6_BC1A_D4C01470BEBE__INCLUDED_)

