/*
 * PDCAttenuator.h
 *
 *  Created on: Sep 26, 2014
 *      Author: kma4hi
 */

#if !defined(EA_9EEBD1A7_FCAC_4e9b_B8C4_9A8875EF7034__INCLUDED_)
#define EA_9EEBD1A7_FCAC_4e9b_B8C4_9A8875EF7034__INCLUDED_

#include "./FunctionBase.h"

namespace VolumeManager
{

   // -----------------------------------------------------------------------------
   //
   // class   P a r k - Di s t a n c e - C o n t r o l - V o l u m e - F i l t e r
   //
   //

   class PDCAttenuator  :  public FunctionBase
   {
      public:
         /* constructor */ PDCAttenuator (PropertyStore& properties, const Configuration& config
               , const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~PDCAttenuator ();


         // IFunction implementation
         virtual tenFunctionType enGetType ();
         // break on volume command
         virtual void vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData);
         // apply attenuation
         virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

         // CCA support
         bool bProcessPDCCommand (midw_fi_tcl_e8_PDCAttenuation::tenType PDCAttenuationCommand, tU16& u16Error);
         bool bProcessPDCLevel (tU8 PDCAttenutionLevel, tU16& u16Error);

      private:
         // member variables
         enum tenAttenuationStatus
         {
            Inactive = 0,
            Active,
            WaitForBreakingVolumeCommand
         } _enAttenuationStatus;
         Array<tU8>  _attenuationValues;
         tenVolumeMode _enCurrentMode;

         // helper functions
         tU8 newVolumeAfterBreak ();
         tU8 attenuatedVolume (tU8 intendedVolume);
         void vPopulateAttenuationValues (const char* pParams);
         bool bIsApplicable();
    };

   // -----------------------------------------------------------------------------

}




//#endif /* PDCATTENUATOR_H_ */
#endif // !defined(EA_9EEBD1A7_FCAC_4e9b_B8C4_9A8875EF7034__INCLUDED_)
