//
// VolumeManager/Engine/Functions/HeatProtector.h
//
//  Created on: Sep 26, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_0B0F8431_E10D_44c6_9AAC_A7FA1CC4C949__INCLUDED_)
#define EA_0B0F8431_E10D_44c6_9AAC_A7FA1CC4C949__INCLUDED_
//#ifndef HEATPROTECTOR_H_
//#define HEATPROTECTOR_H_




namespace VolumeManager
{

   // -----------------------------------------------------------------------------
   //
   //                         class  H e a t - P r o t e c t o r
   //
   //

   class HeatProtector  :  public FunctionBase, public IF_MessageObserver<PO_MessageConfig::enID>
   {
      public:
         /* constructor */ HeatProtector (PropertyStore& properties, const Configuration& config
               , const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~HeatProtector ();

         // IFunction implementation
         virtual tenFunctionType enGetType ();
         virtual void vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData);
         virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

         // PostOffice message observer implementation
         virtual void MessageNotification (PO_MessageConfig::enID MsgId);

         bool bProcessReductionCommand (bool downScaling_Active, tU8 reductionInterval, tU16& u16Error);

      protected:
         // internal types
         enum tenBehavior { UndefinedBehavior, IncrementalDecrease };
         enum tenTrigger  { UndefinedTrigger, CCACommand };

         // helper functions
         static tenBehavior enGetBehaviorFromParams (const char* pParams);
         static tenTrigger  enGetTriggerFromParams (const char* pParams);
         static OSAL_tMSecond getIntervalFromParams (const char* pParams);
         static tU8           u8GetMinimumReductionFromParams (const char* pParams);
         bool bIsActive ();
         bool bIsApplicable (tenFadingReason enReason, const VolumeData& volumeData);
         void vExecuteDecrement ();
         void vHandleTimerEvent (OSAL_tMSecond now);
         void vHandleDiagResult (tenErrorSite enErrorSite, tenErrorCode enErrorCode, tenErrorValue enErrorValue);
         bool bPopulateReductionStatus (midw_mascffi_tclMsgOverTempReductionStatus& fistatus);

         // member variables
         tenBehavior   _behavior;
         tenTrigger    _trigger;
         OSAL_tMSecond _interval;
         tU8           _u8MinimumReductionStep;
         OSAL_tMSecond _invocationTime;
         OSAL_tMSecond _latestUpdateTime;
    };

   // -----------------------------------------------------------------------------

}


//#endif /* HEATPROTECTOR_H_ */
#endif // !defined(EA_0B0F8431_E10D_44c6_9AAC_A7FA1CC4C949__INCLUDED_)
