//
// VolumeManager/Engine/Functions/VolumeAdjustmentFunctionBase.h
//
//  Created on: Sep 23, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_DFB7035D_6F57_4101_8ABB_3C1BA0755185__INCLUDED_)
#define EA_DFB7035D_6F57_4101_8ABB_3C1BA0755185__INCLUDED_
//#ifndef FUNCTIONBASE_H_
//#define FUNCTIONBASE_H_

class VolumeData;

#include "./IFunction.h"
#include "Volume/Utilities/Array.hpp"

namespace VolumeManager
{

   class PropertyStore;
   class Configuration;
   class StreamSet;
   struct GroupConfig;
   struct FunctionConfig;

   // -----------------------------------------------------------------------------

   class FunctionBase   : public IFunction
   {
      public:
         /* constructor */ FunctionBase (PropertyStore& properties, const Configuration& config, const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~FunctionBase ();

         // default (neutral) IFunction implementation
         virtual void vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData);
         virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

      protected:
         // parameter extraction helper functions
         static const char* pGetParameterValue (const char* pParams, const char* pParamName);
         static unsigned    getParameterLength (const char* pParam);
         static unsigned    getEntryLength (const char* pGroupRefEntry);
         static const char* pGetNextEntry (const char* pGroupRefEntry);

         // check, whether given sourceGroup is listed internally (returns also true if list is empty)
         bool affectsVolumeGroup (tU8 volumeGroup);

      private:
         void vPopulateGroupRefs (const char* pGroupRefString);

      protected:
         // member variables
         PropertyStore& _properties;
         const Configuration& _config;
         StreamSet&     _streamSet;
         const char*  _pFunctionName;
         Array<const GroupConfig*>  _groupRefs;
    };

   // -----------------------------------------------------------------------------

}



//#endif /* FUNCTIONBASE_H_ */
#endif // !defined(EA_DFB7035D_6F57_4101_8ABB_3C1BA0755185__INCLUDED_)
