//
// AttenuationFilter.h
//
//  STREAMS ATTENUATION
//
//  Created on: Aug 29, 2016
//      Author: REJ1KOR
//

#if !defined(_ATTENUATIONFILTER_H_)
#define _ATTENUATIONFILTER_H_

#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADASBeepType.h"
namespace VolumeManager
{
  class SourceGroup;
  class SourceConfig;
  class Stream;

  // -----------------------------------------------------------------------------
  //
  //      class  A T T E N U A T I O N - F I L T E R
  //
  //------------------------------------------------------------------------------

  class AttenuationFilter  :  public FunctionBase, public IF_MessageObserver<PO_MessageConfig::enID>

  {
  public:
    /* constructor */ AttenuationFilter(PropertyStore& properties, const Configuration& config
          , const FunctionConfig& functionCfg, StreamSet& streamSet);
    virtual /* destructor */ ~AttenuationFilter();

    // IFunction implementation
    virtual tenFunctionType enGetType ();
    virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

    // PostOffice message observer implementation
    virtual void MessageNotification (PO_MessageConfig::enID MsgId);

  private:
    // helper functions
    void vSetAmplifierVolume (tU8 u8MainVolumeUserStep, tS16 dbValue, tenStream Stream) const;
    void vSetPremium2AmplifierVolume (tU8 u8MainVolumeUserStep, tS16 dbValue);
    void vRestorePremium2Mix1AmplifierVolume ();
    void vRestorePremium2Mix2AmplifierVolume ();
    bool bIsMix1SrcActive() const;
    bool bIsSPISrcActive() const;
    bool bIsSPIDuckingActive() const;
    bool bIsCANAttenuationActive() const;
    bool bIsADASBeepsActive() const;
    bool bIsFAPAttenuationActive() const;

    void vHandleSPIMixVolumePOMsg(PO_MessageConfig::enID MsgId);
    void vHandleIntSourcePOMsg(PO_MessageConfig::enID MsgId);
    void vHandleNotifyMutePOMsg(PO_MessageConfig::enID MsgId);
    void vHandleCANAttenuationPOMsg(PO_MessageConfig::enID MsgId);
    void vHandleCANPartialMuteAttenuationPOMsg(PO_MessageConfig::enID MsgId);
    void vHandleADASBeepActivePOMsg(PO_MessageConfig::enID MsgId);
    void vHandleSetVolumePOMsg(PO_MessageConfig::enID MsgId);
    void vHandleFAPAttenuationPOMsg(PO_MessageConfig::enID MsgId);

    void vGetNaviVolAttenuationLevel(tU8& VolStep, tS16& dB);
    void vGetSPIDuckingVolAttenuationLevel(tU8& VolStep, tS16& dB);
    tS16 vGetCANAttenuationLevel(tU8 Volstep, Stream* pStream);

    void vComputeAndAttenuateMainStreamVolumeLevel();
    void vComputeAndAttenuateMix1StreamVolumeLevel();
    void vComputeAndAttenuateMix2StreamVolumeLevel();
    void vComputeAndPushNaviAttenuationLevel(vector<tS16>&, tU8 Volstep);
    void vComputeAndPushSPIDuckingAttenuationLevel(vector<tS16>&, tU8 Volstep);
    void vComputeAndPushCANAttenuationLevel(vector<tS16>&,tU8 Volstep, Stream* pStream);
    void vComputeAndPushADASBeepAttenuationLevel(vector<tS16>&,tU8 Volstep, Stream* pStream);

    bool bCheckIfAttenuationStillRequiredOnMainStream();
    bool bCheckIfAttenuationStillRequiredOnMixStreams();
    bool bCheckAttenuationViaCANactive();

    void vRestorePreviousvolumeOnStream(tenStream Stream);
    void vCheckAndSetActiveStream();
    void vSetActiveStreamAndParameters(tenStream instream);
    void vCheckAndRestoreVolumeLevels();

    tU8  u8GetStreamCurrentVolumeStep(tenStream Stream);
    tU8  u8GetActiveSourceTypeInStream(tenStream Stream);
    tU8  u8GetClusterSoundLevel() const;
    tS16 s16GetADASBeepAttenuationLevel() ;
    tU8  u8GetCalculatedTargetStep (const VolumeData& data, tU8 currentVol);
    tS16 s16GetAttenuatedDbLevel(tenStream);
    tU8  u8GetUPAEOLLevelOffset();

    void vResetAttenuationDBLevelOnStream(tenStream inStream);
    void vApplyLimits(tU8& Step, const SourceConfig* pSrcConfig);

    bool _bMix1SrcActiveFlag;
    bool _bSPIInfoSrcActiveFlag;
    bool _bSPIDuckingActiveFlag;
    bool _bSPICarplayDuckingActiveFlag;
    bool _bCANAttenuationActiveFlag;
    bool _bCANPartialMuteAttenuationActiveFlag;
    bool _bADASAttenuationActiveFlag;
    bool _bCheckVolumeChangeAllowed;
    bool _bFAPAttenuationActiveFlag;

    tS16 _s16SPIDuckingVolAttenuationLevel;
    tS16 _s16NaviVolAttenuationLevel;
    tS16 _s16MainStreamAttenuationdBvalue;
    tS16 _s16Mix1StreamAttenuationdBvalue;
    tS16 _s16Mix2StreamAttenuationdBvalue;
    tS16  _s16AdasBeepVolume;
  tS16  _s16AttenuationValue;
    tU8   _u8soundConfig;
  tS16 _s16PrevAttenuationVal;

    tenStream enStreamcheck;
    tenAdasBeeptype _enAdasBeeptype;
    tenSPIMixMode _enDuckingActive;

    VolumeData _Voldata;
    // member variables
  };

  // -----------------------------------------------------------------------------

}  // namespace VolumeManager


#endif // !defined(_ATTENUATIONFILTER_H_)
