//
// VolumeManager/Engine/Actions/SourceSwitchActionWhenMixActive.cpp
//
//  Created on: Oct 12, 2015
//      Author: rej1kor (RBEI/ECV2)
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

#include "Volume/Types.h"  // implicitly links <midw_fi_if.h> for alltypes.h and <stl_pif.h> for vector
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IAction.h"
#include "./ActionBase.h"
#include "./SourceSwitchActionWhenMixActive.h"
// - - - - - - - - - - - - -
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>



#include <vector>
#include <algorithm>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



using namespace std;
#include "Volume/VolumeManager.h"
#include "Volume/Configuration/dBCalculator.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/TypeConversions/Functions.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/PropertyStore.h"

#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSourceData.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/AmpVolumeData.h"
#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/SourceSwitchActionWhenMixActive.cpp.trc.h"

namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */  SourceSwitchActionWhenMixActive:: SourceSwitchActionWhenMixActive (PropertyStore& properties, const Configuration& config, const VolumeSourceData& data)
      : ActionBase(properties, config)
      ,_data(data)
   {
    u8CurSrcVolStep = 0;
     ETG_TRACE_USR4(("SourceSwitchActionWhenMixActive entered."))
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ SourceSwitchActionWhenMixActive:: ~SourceSwitchActionWhenMixActive ()
   {

   }

  // -----------------------------------------------------------------------------
  tS16 SourceSwitchActionWhenMixActive::s16GetCurrentVolumeDBLevel(StreamSet& streamSet, tU8 grptype)
  {
    const tU8* pCurrentVolume = _properties.pGetVolume(streamSet.enGetResource(), grptype);

    if(_data.m_Source == AUD_INT_SRC_FM_TA || _data.m_Source == AUD_INT_SRC_DAB_TA)
         {

           #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_TA_DAN
          const tU8* pEntVolume  = _properties.pGetVolume(streamSet.enGetResource(), midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT);

  if(pEntVolume)
    u8CurSrcVolStep = (tU8)(*pEntVolume + _properties.s8GetDanValue());  //gen4 prio3 warning fix
#else
  if(pCurrentVolume)
    u8CurSrcVolStep = *pCurrentVolume;
#endif
  ETG_TRACE_USR4(("SourceSwitchActionWhenMixActive : vExecute FM_TA entered. Volstep : %d, DAN : %d", u8CurSrcVolStep, _properties.s8GetDanValue()));
      }
    else
      {
  if(pCurrentVolume)
    u8CurSrcVolStep = *pCurrentVolume;
      }

    const dBCalculator* pCalc = _config.pGetDBCalculator(_properties.enGetCurrentSource());
    if(pCalc == NULL)
      return MUTE;

    return ( pCalc->s16GetdBValue(u8CurSrcVolStep, EN_AUDIO_SOURCE_STREAM_DEFAULT) );

  }

  // -----------------------------------------------------------------------------
  tS16 SourceSwitchActionWhenMixActive::s16GetDBLevelToADR(tenInternalSource Insource, tS16 CurVolStepDBLevel)
  {
    const dBCalculator* pCalc = _config.pGetDBCalculator(_properties.enGetCurrentSource());
    if(pCalc == NULL)
      return MUTE;

    tS16 DB = MUTE;

    vector<tS16> dBvector;
    dBvector.clear();

    // If incoming source is entertainment, then check NAV and Ducking Attenuation level
    if(Stream::isEntertainmentSource(Insource)
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CHERYM31T    //For chery we have to attenuate Phone and Ringtone vol when Navi is active. To be reworked later.
       || (AUD_INT_SRC_PHONE_OUTBAND_RING == Insource || AUD_INT_SRC_PHONE == Insource) )
#else
      )
#endif
      {
  if(_properties.bIsMix1Active())
    {
      // calculate limited dB-value for amplifier
      tS16 voldb   = pCalc->s16GetdBValue(u8CurSrcVolStep, EN_AUDIO_SOURCE_STREAM_MAIN);

      if(voldb < CurVolStepDBLevel)
        dBvector.push_back(voldb);
    }

  if(_properties.bIsSPIDuckingActive() && (_properties.s16GetSPIDuckingLevel() < CurVolStepDBLevel) )
    {
      dBvector.push_back(_properties.s16GetSPIDuckingLevel());
    }
      }

    if(_properties.bIsCANAttenuationActive() && (_properties.s16GetCANAttenuationLevel() < CurVolStepDBLevel) )
      {
  dBvector.push_back(_properties.s16GetCANAttenuationLevel());
      }

    if(_properties.bIsADASAttenuationActive() && (_properties.s16GetADASAttenuationLevel() < CurVolStepDBLevel) )
      {
  dBvector.push_back(_properties.s16GetADASAttenuationLevel());
      }

    if(!dBvector.empty())
      {
  //Fetch the lowest attenuation value and send the dbvalue to ADR3.
  sort(dBvector.begin(), dBvector.end());
  DB = static_cast<tS16>(dBvector.front() * dBCalculator::dBStepMultiplicator);
  ETG_TRACE_USR4(("SourceSwitchActionWhenMixActive : Final computed Attenuation Volume to be set: %d", DB))
      }
    else
      {
  DB   = static_cast<tS16>(CurVolStepDBLevel * dBCalculator::dBStepMultiplicator);
  ETG_TRACE_USR4(("SourceSwitchActionWhenMixActive : No attenuation to be set. Set current volume : %d",DB))
      }

    return DB;
  }

  // -----------------------------------------------------------------------------

  /* virtual */ void SourceSwitchActionWhenMixActive:: vExecute (StreamSet& streamSet)
  {
    ETG_TRACE_USR4(("SourceSwitchActionWhenMixActive : vExecute entered for sink %d",streamSet.enGetResource()));

    tenStream enStreamID = fiAudioChannel_StreamID_Map::getSecond(_data.m_Channel);
    tenResource enResource = streamSet.enGetResource();
    Stream* pStream = streamSet.pGetStream(enStreamID);
    Ramp ramp = streamSet.queryRamp(EN_AUDIO_FADING_NOTIFY_SET_NAV_ATTENUATION, EN_AUDIO_FADING_RES_USR, enStreamID);

    tenInternalSource IncomingSource = _data.m_Source;

#ifdef VARIANT_S_FTR_ENABLE_DEVICE_SPECIFIC_PHONE_VOL
    if(_data.m_Source == AUD_INT_SRC_PHONE)
      IncomingSource = _properties.u8GetPhoneType();
#endif

    const SourceConfig* pSourceCfg = _config.pGetSourceConfig(IncomingSource);

    if(pSourceCfg)
      {
  tS16 CurVolDBLevel = s16GetCurrentVolumeDBLevel(streamSet, pSourceCfg->u8GetGroupType());

  if (pStream)
    {
      AmpVolumeData AmpData;
    AmpData.m_enStream = pSourceCfg->enGetStreamID(enResource);
      AmpData.m_VolStep = u8CurSrcVolStep;
      AmpData.m_VoldB = s16GetDBLevelToADR(IncomingSource, CurVolDBLevel);

      if(IncomingSource == AUD_INT_SRC_TCU_ECALL)
        {
    //For E-CALL, Attenuation should not be applied during background Source change.
    AmpData.m_VoldB   = static_cast<tS16>(CurVolDBLevel * dBCalculator::dBStepMultiplicator);
        }

      pStream->vSetCurrentSource(IncomingSource);
      AmpData.m_RampLin = ramp.lin;
      AmpData.m_RampdB = ramp.dB;
      AmpData.m_Sink = (unsigned int)enResource;
      VolumeManager::vLaunchAmplifierCommand(AmpData);
    }
      }
  }

  // -----------------------------------------------------------------------------

}  // namespace VolumeManager
