//
// VolumeManager/Engine/Actions/ListChangeAction.h
//
//  Created on: Sep 18, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_DCA63809_13EE_4078_ABBE_0B84EB3943C8__INCLUDED_)
#define EA_DCA63809_13EE_4078_ABBE_0B84EB3943C8__INCLUDED_


class midw_fi_tcl_Aud_VolumeStatusList;



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class OnVolumeLimitAction   : public ListChangeAction
   {
      // Action to limit volumes to their specified Startup-Limits
      //
      // Here we reuse the capabilities of ListChangeAction to concurrently modify
      // any arbitrary subset of all configured volumes. All what needs to be done
      // is prepare a list with necessary volume restrictions
      //

      public:
         /* constructor */  OnVolumeLimitAction (PropertyStore& properties, const Configuration& config);
         virtual /* destructor */ ~OnVolumeLimitAction ();
         static tU8 computeCurrentVolBasedOnMinAndMaxVolLimit(tU8 minlimitval, tU8 CurrentVol, tU8 limitval);

      private:
         // Helper functions
         static midw_fi_tcl_Aud_VolumeStatusList getLimitedList (PropertyStore& properties, const Configuration& config);
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


#endif // !defined(EA_DCA63809_13EE_4078_ABBE_0B84EB3943C8__INCLUDED_)
