//
// VolumeManager/Engine/Actions/ListChangeAction.cpp
//
//  Created on: Sep 18, 2014
//      Author: Martin Koch, Fa. ESE
//

// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

#include "Volume/Types.h"  // implicitly links <midw_fi_if.h> for alltypes.h and <stl_pif.h> for vector
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IAction.h"
#include "./ActionBase.h"
#include "./ListChangeAction.h"
// - - - - - - - - - - - - -

#include "./VolumeSetAction.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/TypeConversions/Functions.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/PropertyStore.h"

#include "InternalComponentCommunication/Messages/Volume/IDSetExtAmpVolume.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/ListChangeAction.cpp.trc.h"

class midw_fi_tcl_Aud_VolumeStatusList;

namespace VolumeManager {

// -----------------------------------------------------------------------------

/* constructor */ListChangeAction::ListChangeAction(PropertyStore& properties, const Configuration& config, const midw_fi_tcl_Aud_VolumeStatusList& volumeList) :
        ActionBase(properties, config), _volumeList(volumeList)
{
    ETG_TRACE_USR3(("ListChangeAction() invoked with %u entries", _volumeList.VolumeStatusList.size()))
    for (unsigned i = 0; i < _volumeList.VolumeStatusList.size(); ++i)
    ETG_TRACE_USR4(("\tvolume group: %u\tvolume step = %u\t", _volumeList.VolumeStatusList[i].AudVolumeType.enType, _volumeList.VolumeStatusList[i].Volume))
}

// -----------------------------------------------------------------------------

/* virtual destructor */ListChangeAction::~ListChangeAction()
{

}

// -----------------------------------------------------------------------------

/* virtual */void ListChangeAction::vExecute(StreamSet& streamSet)
{
    tenResource enResource = streamSet.enGetResource();
    const SourceConfig* pSourceConfig = NULL;
    Stream* pActiveStream = streamSet.pGetStream(streamSet.enGetActiveStreamID());
    if (pActiveStream)
        pSourceConfig = _config.pGetSourceConfig(pActiveStream->enGetCurrentSource());

    if (_properties.bIsExtAmpConnected())
    {
        VolumeData data;

        for (size_t j = 0; j < _volumeList.VolumeStatusList.size(); ++j)
        {
            const midw_fi_tcl_Aud_VolumeStatus& entry = _volumeList.VolumeStatusList[j];
            midw_fi_tcl_Aud_VolumeStatusList& lst = _properties.getLocalVolumeList();
            for (size_t j = 0; j < lst.VolumeStatusList.size(); ++j)
            {
                if (entry.AudVolumeType.enType == lst.VolumeStatusList[j].AudVolumeType.enType)
                {
                    if (lst.VolumeStatusList[j].Volume != entry.Volume)
                    {
                        data.m_VolumeGroup = (tenVolumeType) _properties.enGetExtAmpVolumegroup((tU8) lst.VolumeStatusList[j].AudVolumeType.enType);
                        if (entry.Volume > lst.VolumeStatusList[j].Volume)
                        {
                            data.m_VolumeType.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC);
                            data.m_Volume = (tU8)(entry.Volume - lst.VolumeStatusList[j].Volume); //gen4 prio3 compiler warning fix
                        }
                        else if (entry.Volume < lst.VolumeStatusList[j].Volume)
                        {
                            data.m_VolumeType.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC);
                            data.m_Volume = (tU8)(lst.VolumeStatusList[j].Volume - entry.Volume);  //gen4 prio3 compiler warning fix
                        }
                    }
                }
            }

            IDSetExtAmpVolume outMsg(data);
            InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&outMsg);
            _properties.vUpdateVolumeInList(enResource, entry.AudVolumeType.enType, entry.Volume);
        }
    }
    else
    {
        for (size_t j = 0; j < _volumeList.VolumeStatusList.size(); ++j)
        {
            const midw_fi_tcl_Aud_VolumeStatus& entry = _volumeList.VolumeStatusList[j];

#ifdef VARIANT_S_FTR_ENABLE_DEVICE_SPECIFIC_PHONE_VOL
            // Handling if Listchange received for Phone source if Device Specific Phone volume is enabled.
            if(pSourceConfig && midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_PHONE == entry.AudVolumeType.enType)
            {
                // Get the Current Phonetype which is Active
                pSourceConfig = _config.pGetSourceConfig(_properties.u8GetPhoneType());
                if(pSourceConfig!=NULL)//coverity fix
                {
                    //Get corresponding Volume Group Type
                    midw_fi_tcl_e8_Aud_VolumeType::tenType enType = fiVolumeListEntry_Map::getFirst(pSourceConfig->u8GetGroupType());

                    // If Volume change requested for Current Active Phone source, then Forward the volume request to ADR.
                    if(pActiveStream->enGetCurrentSource() == _properties.u8GetPhoneType() && enType == pSourceConfig->u8GetGroupType())
                    {
                        vUpdateActiveSource (streamSet, entry.Volume);
                    }
                    else // Elser Just Update Volume List
                    {
                        // Here We need to Update both Phone Volume Groups
                        _properties.vUpdateVolumeInList(enResource, entry.AudVolumeType.enType, entry.Volume);
                        _properties.vUpdateVolumeInList(enResource, enType, entry.Volume);
                    }
                }
            }
            else //Usual Handling if Listchange not requested for Phone Source
            {
                if (pSourceConfig && (entry.AudVolumeType.enType == pSourceConfig->u8GetGroupType()))
                // delegate to separate Action object
                vUpdateActiveSource (streamSet, entry.Volume);
                else
                // simply store the new value into property store
                _properties.vUpdateVolumeInList(enResource, entry.AudVolumeType.enType, entry.Volume);
            }

#else
            if (pSourceConfig && (entry.AudVolumeType.enType == pSourceConfig->u8GetGroupType()))
                // delegate to separate Action object
                vUpdateActiveSource(streamSet, entry.Volume);
            else
                // simply store the new value into property store
                _properties.vUpdateVolumeInList(enResource, entry.AudVolumeType.enType, entry.Volume);
#endif
        }
    }
}

// -----------------------------------------------------------------------------

void ListChangeAction::vUpdateActiveSource(StreamSet& streamSet, tU8 volume)
{
    VolumeData volumeData;
    volumeData.setResource(fiResource_Map::getFirst(streamSet.enGetResource()));
    volumeData.m_Channel = fiAudioChannel_StreamID_Map::getFirst(streamSet.enGetActiveStreamID());
    volumeData.setVolumeType(midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS);
    volumeData.m_Volume = volume;
    // volumeData.m_VolumeGain = XXX;  // not used

    // delegate to VolumeSetAction object
    VolumeSetAction(_properties, _config, volumeData, EN_AUDIO_FADING_RES_USR).vExecute(streamSet);
}

// -----------------------------------------------------------------------------

}// namespace VolumeManager
