//
// VolumeManager/Configuration/ConfigurationParser.h
//
// helper to populate Stream objects from Configuration.XML information
//
//  Created on: Jul 10, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_023E2ACF_41BD_4ac2_8C77_00BB5C5A9262__INCLUDED_)
#define EA_023E2ACF_41BD_4ac2_8C77_00BB5C5A9262__INCLUDED_
//#ifndef XMLPARSER_H_
//#define XMLPARSER_H_


// -----------------------------------------------------------------------------

struct _xmlDoc;
struct _xmlXPathContext;
struct _xmlXPathObject;
struct _xmlNode;
struct _xmlNodeSet;

// -----------------------------------------------------------------------------


namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class dBCalculator;
   struct FunctionConfig;
   struct StreamConfig;
   struct StreamSetConfig;
   struct GroupConfig;
   class SourceConfig;
   struct VolumeConstraints;

   // -----------------------------------------------------------------------------

   class XMLParser
   {
   public:
      /* constructor */ XMLParser();
      /* destructor */ ~XMLParser();

      void vPopulateFunctions (/* output */ FunctionConfig*& pFunctions, size_t& functionCount);
      void vPopulateCalculators (/* output */ dBCalculator*& pCalculators, size_t& calculatorCount);

      void vPopulateStreamSets (FunctionConfig* pFunctions, size_t functionCount
            , /* output */ StreamSetConfig*& pSets, size_t& setCount
            , StreamConfig*& pStreams, size_t& streamCount, dBCalculator* pCalculators, size_t calccount);

      void vPopulateSourceGroups (StreamConfig* pStreams, size_t streamCount
            , dBCalculator* pCalculators, size_t calculatorCount
            , /* output */ const StreamConfig**& ppMappedStreams
            , GroupConfig*& pGroups, size_t& groupCount);

      void vPopulateSources (GroupConfig* pGroups, size_t groupCount
            , /* output */ SourceConfig*& pSources, size_t& sourceCount);

   private:
      void vPopulateRelatedSinks(_xmlNode* pGroupNode, const StreamConfig* pStreams, size_t streamCount
            , const StreamConfig** ppMappedStreams, /* out */ size_t& sinkCount);
      void vPopulateVolumeLimits(_xmlNode* pVolumeSettings, dBCalculator* pCalculator, /* out */ VolumeConstraints& volumeLimits);

      static const char* getAttribute (_xmlNode* node, const char* attributeName);
      static _xmlNode* getChildElement (_xmlNode* node, const char* elementName);
      static _xmlNode* getNextSibling (_xmlNode* node);
      static size_t getChildCount (_xmlNode* node, const char* elementName);

      tenStream enGetStreamIDFromName (const char* streamName);
      static tenResource enGetResourceIDFromName (const char* resourceName);

   private:
      _xmlDoc*          _document;
      _xmlXPathContext* _context;

      _xmlXPathObject*  _streamNodes;
   };

   // -----------------------------------------------------------------------------

}


//#endif /* XMLPARSER_H_ */
#endif // !defined(EA_023E2ACF_41BD_4ac2_8C77_00BB5C5A9262__INCLUDED_)
