//
// CCAListener.cpp   for sub-component VolumeManager
//
//  Created on: Jun 18, 2014
//      Author: Martin Koch, Fa. ESE
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>


//Include public FI interface of this service.
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include <midw_fi_if.h>


#define AMT_S_IMPORT_INTERFACE_GENERIC
#include <amt_if.h>


#include "CCAListener.h"
// - - - - - - - - - - -
//include datapool files
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

// local headers
#include "Volume/Types.h"
#include "Volume/TypeConversions/Functions.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_VolumeMode.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_VolumeLock.h"


#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/CCAListener.cpp.trc.h"

#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

tU8 u8CptMaxVolMaxVal;
tU8 u8CptMaxVolMinVal;
tU8 u8CptMinVolMaxVal;
tU8 u8CptMinVolMinVal;

enum limits{
   MIN_ON_ENT_VOl =15,
  MAX_ON_ENT_VOl= 30,
   MIN_MIN_VOL_LIMIT= 0,
   MAX_MIN_VOL_LIMIT =15
};
#else
//#define MIN_ON_ENT_VOl 10
//#define MAX_ON_ENT_VOl 20
enum limits{
   MIN_ON_ENT_VOl= 10,
  MAX_ON_ENT_VOl =20,
   MIN_MIN_VOL_LIMIT=1,
   MAX_MIN_VOL_LIMIT= 10
};
#endif

namespace VolumeManager
{

   // =============================================================================
   //
   //                      ---   file-scoped helper functions   ---
   //

   // --------------------------------------------------------------------------

   void handleVolumeMode_MethodStart (const midw_mascffi_tclMsgVolumeModeMethodStart& data)
   {
      // launch PO message for incoming CCA message:  VolumeMode.MethodStart

      // setup outgoing PO message
      VolumeModeData outData;
      switch (data.VolumeMode.enType)  //#ma.wka.currently CCA message don't pass the channel
      {
         case midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_NAV_ANNOUCEMENT:
         case midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_NAV_VOL:
         case midw_fi_tcl_e8_VolumeMode::FI_EN_AUDIO_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL:
            outData.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX;
            break;

         default:
            outData.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
            break;
      }
      outData.m_Resource = data.Resource.enType;
//      midw_fi_tcl_e8_SourceNo::tenType m_Source;
     outData.m_VolumeModeType = fiVolumeMode_Map::getSecond(data.VolumeMode.enType);

      ID_CCA_Start_VolumeMode outMsg(outData);
      InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

      ETG_TRACE_USR2(("VolumeManager - CCAListener - forwarded VolumeMode.MethodStart for Mode = %u"
            , ETG_CENUM(tenVolumeMode, outData.m_VolumeModeType)))
   }

   // --------------------------------------------------------------------------

   void handleVolume_Set (const midw_mascffi_tclMsgVolumeSet& data)
   {
      // launch PO message for incoming CCA message:  Volume.Set

      // filter for invalid messages
      if (data.VolumeType.enType == midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_NOT_DEF )
      {
         ETG_TRACE_USR1(("VolumeManager - CCAListener: invalid VolumeType: request rejected"))
         return;
      }

      // setup outgoing PO message
      VolumeData out;
      out.setVolume(data.Volume);
      out.setResource(data.Resource.enType);
      out.setVolumeType(data.VolumeType.enType);
      out.m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;  // don't have this information here
      //tS16 m_VolumeGain;

      ETG_TRACE_USR1(("VolumeManager - CCAListener: Resource %d, channel was set to %d here",data.Resource.enType,out.m_Channel));

      ID_CCA_Start_Volume outMsg(out);
      InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

      ETG_TRACE_USR2(("VolumeManager - CCAListener: - forwarded Volume.Set for Type = %d, Resource = %d, Volume = %d"
         , out.getVolumeType(), out.getResource(), out.getVolume() ))
   }

   // --------------------------------------------------------------------------

   void handleVolumeLock_Set (const midw_mascffi_tclMsgVolumeLockSet& data)
   {
      // launch PO message for incoming CCA message:  VolumeLock.Set

      ID_CCA_Start_VolumeLock outMsg(fiVolumeLockState_Map::getSecond(data.VolumeLockType.enType)
         , fiVolumeLockRequester_Map::getSecond(data.Requester.enType));
      InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
   }
   //--------------------------------------------------------------------------------
   void vhandleVolume_EntOnVolume (const midw_mascffi_tclMsgEntOnVolumeSetupSet& data)
      {
     dp_tclAudioManagerDPEntOnVolumeSet limitvolume;
     tU8 val = 0;

     if (data.SoundType.enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
     {
      if((data.LimitValue >= MIN_ON_ENT_VOl) && (data.LimitValue <= MAX_ON_ENT_VOl))
      {
        val = data.LimitValue;
       limitvolume.s32SetData(val);
       ETG_TRACE_USR2(("VolumeManager - CCAListener: - Ent On Volume limit = %d", val ))
      }
      else if (data.LimitValue > MAX_ON_ENT_VOl)
      {
        val = MAX_ON_ENT_VOl;
        limitvolume.s32SetData(val);
      }
      else if(data.LimitValue < MIN_ON_ENT_VOl)
      {
        val = MIN_ON_ENT_VOl;
        limitvolume.s32SetData(val);
      }
     }
     else if(data.SoundType.enType  == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
     {
         limitvolume.s32GetData(val);
         val = static_cast<tU8>(data.LimitValue + val);
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

       if(val >= u8CptMaxVolMaxVal)
       {
         val = u8CptMaxVolMaxVal;
       }

       limitvolume.s32SetData(val);

#else
         if(val >= MAX_ON_ENT_VOl)
         {
           val = MAX_ON_ENT_VOl;
           limitvolume.s32SetData(val);
         }
         else
         {
           limitvolume.s32SetData(val);
         }
#endif
         ETG_TRACE_USR2(("VolumeManager - CCAListener: - Ent On Volume limit = %d", val ))
     }
     else if (data.SoundType.enType  == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
     {
       limitvolume.s32GetData(val);
       val =  static_cast<tU8>(val- data.LimitValue) ;
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

       if(val <= u8CptMaxVolMinVal)
       {
         val = u8CptMaxVolMinVal;
       }

       limitvolume.s32SetData(val);

#else
       if(val <= MIN_ON_ENT_VOl)
       {
         val = MIN_ON_ENT_VOl;
         limitvolume.s32SetData(val);
       }
       else
       {
         limitvolume.s32SetData(val);
       }
#endif
       ETG_TRACE_USR2(("VolumeManager - CCAListener: - Ent On Volume limit = %d", val ))
     }

      }
   void vhandleVolume_MinimumVolumeLimit (const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& data)
         {
      dp_tclAudioManagerDPMinimumOnVolLimit limitvolume;
        tU8 val = 0;

        if (data.SoundType.enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
        {
         if((data.LimitValue >= MIN_MIN_VOL_LIMIT) && (data.LimitValue <= MAX_MIN_VOL_LIMIT))
         {
           val = data.LimitValue;
          limitvolume.s32SetData(val);
          ETG_TRACE_USR2(("VolumeManager - CCAListener: - Minimum On Volume limit = %d", val ))
         }
         else if (data.LimitValue > MAX_MIN_VOL_LIMIT)
         {
           val = MAX_MIN_VOL_LIMIT;
           limitvolume.s32SetData(val);
         }
         else if(data.LimitValue < MIN_MIN_VOL_LIMIT)
         {
           val = MIN_MIN_VOL_LIMIT;
           limitvolume.s32SetData(val);
         }
        }
        else if(data.SoundType.enType  == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
        {
            limitvolume.s32GetData(val);
            val = static_cast<tU8>(data.LimitValue + val);
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

         if(val >= u8CptMinVolMaxVal)
         {
           val = u8CptMinVolMaxVal;
         }

         limitvolume.s32SetData(val);

#else
            if(val >= MAX_MIN_VOL_LIMIT)
            {
              val = MAX_MIN_VOL_LIMIT;
              limitvolume.s32SetData(val);
            }
            else
            {
              limitvolume.s32SetData(val);
            }
            ETG_TRACE_USR2(("VolumeManager - CCAListener: - Minimum On Volume limit = %d", val ))
#endif
        }
        else if (data.SoundType.enType  == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
        {
          limitvolume.s32GetData(val);
          val =  static_cast<tU8>(val- data.LimitValue) ;
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

         if(val <= u8CptMinVolMinVal || val > u8CptMinVolMaxVal )
         {
           val = u8CptMinVolMinVal;
         }

         limitvolume.s32SetData(val);

#else
          if(val <= MIN_MIN_VOL_LIMIT)
          {
            val = MIN_MIN_VOL_LIMIT;
            limitvolume.s32SetData(val);
          }
          else
          {
            limitvolume.s32SetData(val);
          }
#endif
          ETG_TRACE_USR2(("VolumeManager - CCAListener: -Minimum On Volume limit = %d", val ))
        }
         }
   //--------------------------------------------------------------------------------

   // =============================================================================
   //
   //                 ---   class implementation   ---
   //

   // --------------------------------------------------------------------------

   /* constructor */ CCAListener:: CCAListener ()
   {
      ETG_TRACE_USR2(("VolumeManager - CCAListener established"))

#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

       if(DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "CptMaxVolMaxVal", &u8CptMaxVolMaxVal, 1))
       {
           ETG_TRACE_USR3(("Max Volume Max value on volume limit range received from KDS =%d ",u8CptMaxVolMaxVal ))
       }


       if(DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "CptMaxVolMinVal", &u8CptMaxVolMinVal, 1))
       {
         ETG_TRACE_USR3(("Max Volume Min value on volume limit range received from KDS =%d ",u8CptMaxVolMinVal ))
       }


      if(DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "CptMinVolMaxVal", &u8CptMinVolMaxVal, 1))
       {
         ETG_TRACE_USR3(("Min Volume Max value on volume limit range received from KDS =%d ",u8CptMinVolMaxVal ))
       }


      if(DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "CptMinVolMinVal", &u8CptMinVolMinVal, 1))
      {
        ETG_TRACE_USR3(("Min Volume Min value on volume limit range received from KDS =%d ",u8CptMinVolMinVal ))
      }

      if(u8CptMinVolMinVal > u8CptMinVolMaxVal)
      {
        u8CptMinVolMinVal = MIN_MIN_VOL_LIMIT;
        u8CptMinVolMaxVal = MAX_MIN_VOL_LIMIT;
      }
      else if(u8CptMaxVolMinVal > u8CptMaxVolMaxVal)
      {
        u8CptMaxVolMinVal = MIN_ON_ENT_VOl;
        u8CptMaxVolMaxVal = MAX_ON_ENT_VOl;
      }

#endif

   }

   // --------------------------------------------------------------------------

   /* virtual destructor */ CCAListener:: ~CCAListener ()
   {
      ETG_TRACE_USR2(("VolumeManager - CCAListener terminated"))
   }

   // --------------------------------------------------------------------------

   tVoid CCAListener:: vOnMethodStart (tU16 u16FunctionId, amt_tclServiceData& inMessage)
   {
      fi_tclVisitorMessage visitor(&inMessage);

      switch (u16FunctionId)
      {
         case MIDW_MASCFFI_C_U16_VOLUMEMODE:
            {
               // get local data structure from incoming message
               midw_mascffi_tclMsgVolumeModeMethodStart data;
               visitor.s32GetData(data);

               handleVolumeMode_MethodStart(data);

               // cleanup
               data.vDestroy();
            }
            break;

         default:
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: unsupported FunctionID 0x%X", u16FunctionId))
            break;
      }
   }

   // --------------------------------------------------------------------------

   tBool CCAListener:: bProcessSet (amt_tclServiceData& inMessage, tBool& bPropertyChanged, tU16& u16Error)
   {
      // avoid automatic CCA client notification - inform caller that we handle this ourselves
      bPropertyChanged = FALSE;

      tU16 functionID = inMessage.u16GetFunctionID();
      fi_tclVisitorMessage visitor(&inMessage);
      switch (functionID)
      {
         case MIDW_MASCFFI_C_U16_VOLUME:
            {
               // get local data structure from incoming message
               midw_mascffi_tclMsgVolumeSet data;
               visitor.s32GetData(data);

               handleVolume_Set(data);

               // cleanup
               data.vDestroy();
            }
            break;

         case MIDW_MASCFFI_C_U16_VOLUMELOCK:
            {
               // get local data structure from incoming message
               midw_mascffi_tclMsgVolumeLockSet data;
               visitor.s32GetData(data);

               handleVolumeLock_Set(data);

               // cleanup
               data.vDestroy();
            }
            break;

         case MIDW_MASCFFI_C_U16_PDCATTENUATION:
         case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL:
            // nothing to do here; they are forwarded by Engine directly to PDCAttenuator
            u16Error = MIDW_MASCFFI_C_U16_ERROR_INTERNALFAILURE;
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: accidentally received PDC-command %u"
                  , inMessage.u16GetFunctionID()))
            break;

         case MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION:
            // nothing to do here; should be forwarded by Engine directly to HeatProtector
            u16Error = MIDW_MASCFFI_C_U16_ERROR_INTERNALFAILURE;
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: accidentally received HeatProtector-command %u"
                  , inMessage.u16GetFunctionID()))
            break;
         case MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP:
         {
           midw_mascffi_tclMsgEntOnVolumeSetupSet data;
           visitor.s32GetData(data);
           vhandleVolume_EntOnVolume(data);
           data.vDestroy();
         }
        break;
         case MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP:
    {
      ETG_TRACE_USR4(("MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP here in cca listener"));
      midw_mascffi_tclMsgMinimumOnVolumeSetupSet data;
       visitor.s32GetData(data);
       vhandleVolume_MinimumVolumeLimit(data);
       data.vDestroy();
       }
      break;
         default:
            u16Error = MIDW_MASCFFI_C_U16_ERROR_INTERNALFAILURE;
            ETG_TRACE_FATAL(("VolumeManager - CCAListener::vOnMethodStart: unsupported FunctionID 0x%X", inMessage.u16GetFunctionID()))
            break;
      }

      return TRUE;
   }

   // --------------------------------------------------------------------------


}  // namespace VolumeManager
