/**
* @file TuningDataServiceMessage.cpp
* @author CM-AI wie1hi
* @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
* @addtogroup fc_audiomanager
* @{
*/

#include "../../../../../ai_osal_linux/components/system/system_types.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>

#include "../../fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_TUNING_DATA_SERVICE
#include "trcGenProj/Header/TuningDataServiceMessage.cpp.trc.h"
#endif

#include "TuningDataServiceMessage.h"

/**
 * Constructor
 */
TuningDataServiceMessage::TuningDataServiceMessage():
preface(0), version(0), serviceID(0), dataLength(0), data(OSAL_NULL), allocatedLength(0)
{
}

/**
 * Destructor
 */
TuningDataServiceMessage::~TuningDataServiceMessage()
{
   ETG_TRACE_USR4(("TuningDataServiceMessage: Destructor."));
   free();
}

/**
 * @method getData()
 * @brief Return pointer to data memory
 */
tU8* TuningDataServiceMessage::getData()
{
   return data;
}

/**
 * @method free()
 * @brief frees memory
 */
tVoid TuningDataServiceMessage::free()
{
   if (data != OSAL_NULL)
   {
      ETG_TRACE_USR4(("TuningDataServiceMessage: Free memory @0x%x (%d bytes)", data, allocatedLength));
      OSAL_DELETE[] data;
      data = OSAL_NULL;
      allocatedLength = 0;
   }
}

/**
 * getHeaderSize()
 * @return Size of the message header in bytes
 */
size_t TuningDataServiceMessage::getHeaderSize()
{
   return TUNING_DATA_SERVICE_MESSAGE_HEADER_SIZE;
};

/**
 * allocDataMemory()
 * @description Allocates memory of the given length, which can be accessed through member "data".
 * @param length Intended length of data field to be allocated
 */
tBool TuningDataServiceMessage::allocDataMemory(tU32 length)
{
   ETG_TRACE_USR4(("TuningDataServiceMessage::AllocDataMemory (%d) entered.", length));
   if (data != OSAL_NULL)
   {
      if (length <= allocatedLength)
      {
         ETG_TRACE_USR4(("AllocDataMemory: No realloc needed (has:%d requested:%d).", allocatedLength, length));
         return true;
      }
      else
      {
         ETG_TRACE_USR4(("AllocDataMemory: Delete data (%d bytes)", allocatedLength));
         OSAL_DELETE[] data;
         data = OSAL_NULL;
         allocatedLength = 0;
      }
   }

   if (length > 0)
   {
      data = OSAL_NEW tU8[length]; // exception bad_alloc must not be caught by application
      allocatedLength = length;
      ETG_TRACE_USR4(("AllocDataMemory: Alloc data (%d bytes) @0x%x.", length, data));
   }

   return (data != OSAL_NULL);
}

/**
 * @method bCheckInvariant()
 * @brief Checks if the internal state of the class is consistent. Use for unit testing
 */
tBool TuningDataServiceMessage::bCheckInvariant()
{
   if (allocatedLength == 0 && data != OSAL_NULL)
      return false;

   return true;
}
