/**
 * @file TuningDataService.h
 * @author CM-AI wie1hi
 * @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef TUNINGDATASERVICE_H_
#define TUNINGDATASERVICE_H_

#ifndef ASSERT_STATIC
#define ASSERT_STATIC(_b) { switch(1){ default: case false:break; case (_b):break; }; }
#endif

#ifndef MIN
#define MIN(_a, _b) ((_a) < (_b) ? (_a) : (_b))
#endif
#ifndef MAX
#define MAX(_a, _b) ((_a) > (_b) ? (_a) : (_b))
#endif

/**
 * The port number that the service will be listening to
 */
#define TUNING_DATA_SERVICE_PORT                (0xC601) // (50689)

/**
 * The default threadding priority
 */
#define TUNING_DATA_SERVICE_DEFAULT_PRIO        (133)

/**
 * The default threadding stack size
 */
#define TUNING_DATA_SERVICE_DEFAULT_STACKSIZE   (4096)

/**
 * The buffer size for received TCP messages
 * Must be at least the size of the message header (currently 8 bytes)
 */
#define TUNING_DATA_SERVICE_RECEIVE_BUFFER_SIZE (2048)

/**
 * Maximum size for the data part of the message in bytes.
 */
#define TUNING_DATA_SERVICE_MAX_MSG_DATA_SIZE (0x200000) // ~ 2 MB

/**
 * The size of the response header:
 * ServiceID (1 Byte) + MessageType (1 Byte) = 2 Bytes
 */
#define TUNING_DATA_SERVICE_RESPONSE_HEADER_SIZE (2)

/**
 * The version number range that is currently supported
 */
#define TUNING_DATA_SERVICE_MIN_VERSION (1)
#define TUNING_DATA_SERVICE_MAX_VERSION (1)

//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#include "osal_if.h"

//#define AHL_S_IMPORT_INTERFACE_THREAD
//#include "ahl_if.h"         // standard CCA Server framework

#define REC_BUF_SIZE 2010

//This file has to be present to allow tuning. Without this we will not create the server.
//This should prevent that we keep a socket open by default
#define TUNING_ENABLE_FILE "/var/opt/bosch/dynamic/audio/audio_tuning_enable.txt"

//#include <vector>
//#include <utility>
#include "ITuningDataClient.h"
#include "../../fc_audiomanager_trace_input.h"
#include "../../fc_audiomanager_main.h"

class TuningDataService:public fc_audiomanager_tclTraceInput
{
public:
   /**
    * Do not change! Defined in SW Concept Document!
    */
   enum tenTuningDataServiceId {
      ID_TUNING_DATA_SRV = 0x00,
      ID_BOSCH_SOUND_TOOL = 0x01,
      ID_ARKAMYS_PSA = 0x02,
      ID_ARKAMYS_RNAIVI = 0x03,
      ID_ESE_RNAIVI = 0x04
   };

   /**
    * Do not change! Defined in SW Concept Document!
    */
   enum tenErrorCodes {
      ERR_NO_ERROR_YET           = 0x0000,
      ERR_NO_CUR_ERROR           = 0x0001,
      ERR_PROTOCOL_ERROR         = 0x0002,
      ERR_DATA_LENGTH_TOO_LARGE  = 0x0003,
      ERR_NO_DATA                = 0x0004,
      ERR_UNKNOWN_SERVICE        = 0x0005,
      ERR_UNKNOWN_CMD            = 0x0006,
      ERR_VERSION_NOT_SUPP       = 0x0007,
      ERR_INTERNAL               = 0x0100,
      ERR_UNSPECIFIED            = 0x8000
   };

   /**
    * Do not change! Defined in SW Concept Document!
    */
   enum tenCommands {
      CMD_CMD_AVAIL              = 0x00,
      CMD_SERVICE_AVAIL          = 0x01,
      CMD_GET_SUPP_VERSIONS      = 0x02,
      CMD_GET_MAX_DATA_LENGTH    = 0x03,
      CMD_GET_LAST_ERROR         = 0x04,
      CMD_MAX
   };

   enum tenMessageType {
      MSG_TYPE_RESPONSE          = 0x00,
      MSG_TYPE_ERROR             = 0x01,
      MSG_TYPE_ACK               = 0x02
   };

   static TuningDataService* getInstance();

   virtual ~TuningDataService();

   tBool bStartupServer();
   tBool bRegisterUser();

   tVoid vDataTx(tU8 serviceID, tU8 txHandle, const tU8* data, tU32 size, tU8 msgType = MSG_TYPE_RESPONSE);
   virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);// for handling loopback messages
private:
   tU8* m_pResponseBuffer;
   tU32 m_responseBufferSize;
   TuningDataService();
   TuningDataService(const TuningDataService&);
   TuningDataService& operator = (const TuningDataService&);
   tBool m_bkeepRunning;
   tBool m_bSBRVariant;

   std::vector<std::pair<tenTuningDataServiceId, ITuningDataClient*> > m_vClients;
   /**
    *  Array of active connection handles. Currently one handle is supported.
    *  Code changes needed if more handles are required.
    */
   int m_iActiveConnectionHandles[1];
   tenErrorCodes m_tenlastError; // Must also be adapted to multiple connections if desired

   OSAL_tThreadID       m_hRxThreadId;

   tVoid vGetThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const;

   /**
    * tVoid vStartThread()
    * The thread entry function. Needed for the thread starting procedure
    */
   static tVoid vStartThread(tVoid* pvArg);
   /**
    * vDataRxThread()
    * The thread worker function.
    * This function is listening for data and calls the respective callback functions of the registered clients
    */
   tVoid vDataRxThread();

   /**
    * vProcessRequest()
    * Process a request to the "Meta Services" of this protocol.
    */
   tVoid vProcessRequest(tU32 size, tVoid* data, tU8 txHandle);

   /**
    * bCreateReply()
    * @brief Creates the reply data and writes it into the given buffer
    * @return true if successful
    */
   //tBool bCreateReply(tU8 command, tU8 *pData, tU8 *replyBuf, tU16 bufSize);

   /**
    * Handle error
    */
   tVoid vSetError(tenErrorCodes errCode);

   tBool bRegisterUser(tenTuningDataServiceId id, ITuningDataClient * pReceiver);
   tVoid vCheckSBRConfig();
};

#endif /* TUNINGDATASERVICE_H_ */
