/************************************************************************
 * FILE:         SoundTool_TcpRxTx.h
 * PROJECT:      MIB
 * SW-COMPONENT: AudioManager
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  workthread for handling of TCP IP Rx (Soundtool)
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author   | Modification
 * 20.11.13  | Daniel   | added for MIB
 *************************************************************************/
#ifndef _SOUNDTOOL_TCP_RX_H_
#define _SOUNDTOOL_TCP_RX_H_

#define SOUNDTOOL_DEFAULT_PRIO                133
#define SOUNDTOOL_DEFAULT_STACKSIZE           4096


//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#include "osal_if.h"

//#define AHL_S_IMPORT_INTERFACE_THREAD
//#include "ahl_if.h"         // standard CCA Server framework

#define REC_BUF_SIZE 2010

#define SOUND_TOOL_PORT 0xC600 // (50688)

//enable teh below define to get debug output into
/// "/var/opt/bosch/dynamic/ffs/Soundtool.log"
//#define DEBUG_PRINT

class SoundTool_TcpRxTx;
class SoundToolClient;

class SoundTool_TcpRxTx
{
public:

  SoundTool_TcpRxTx(SoundToolClient* poSoundToolClient);
  virtual ~SoundTool_TcpRxTx();

  // thread loop worker function
  int setUpServer();

  void SocketSend(int size, tU8* pBuf); //send function (called in thread context)

//protected:
  SoundTool_TcpRxTx(); //don't use

private:
  static void vStartThread(tVoid* pvArg);   // the thread entry function
  void SocketReceive(tVoid); // the thread worker function

  tVoid vGetThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const;

  SoundToolClient *m_poSoundToolClient;
  OSAL_tThreadID       _hRxThreadId;

  int temp_sock_desc;

};

#endif // _SOUNDTOOL_TCP_RX_H_
