/**
 * @file ESETuningHandlerRNAIVI.h
 * @author pau4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ESETUNINGHANDLERRNAIVI_H_
#define ESETUNINGHANDLERRNAIVI_H_

#include "ITuningDataClient.h"
#include "EngineSound/RNAIVI/EngineSoundConfigIVI.h"

class ESETuningHandlerRNAIVI : public ITuningDataClient
{
public:
   static ESETuningHandlerRNAIVI* getInstance();
   tVoid DataRx(tU32 size, tVoid* pData, tU8 txHandle);
   tVoid AdrMessageRx(tU16 u16FuncID, tU8* u8data, tU32 len);
   virtual ~ESETuningHandlerRNAIVI();

private:

   //The error codes are kept differnent from those defined in TuningDataService.h
   //General communication and protocol errors are detected in TuningDataService-
   //But those errors are not informed to the tools.
   //However in future if those errors are to be sent to the tool, to avoid possibe
   //conflicts with those error codes, we use different error codes here.
   enum tenErrorCode {
      ERR_UNKNOWN_PARAMID        =0xF000,
      ERR_UNKNOWN_CMDID          =0xF001,
      ERR_INVALID_DATA_LENGTH    =0xF002,
      ERR_PARAM_OUT_OF_RANGE     =0xF003,
      ERR_ADR_RESPONSE           =0xF004,
      ERR_OTHER                  =0xF005
   };

   //static ESETuningHandlerRNAIVI* m_pTheInstance;
   ESETuningHandlerRNAIVI();
   tU8 m_txHandle;

   tU32 m_u32Size;
   tU8 *m_pU8Data;

   tBool m_bWaitEseVolume;
   tBool m_bWaitEseOnOff;
   tBool m_bESEOnOffState;
    enum tenESETuningParamID {
     TUNING_ESE_VERSION = 0x00,
     TUNING_ESE_ONOFF = 0x01,
     TUNING_ESE_VOLUME = 0x02,
     TUNING_ESE_PARAMETER = 0x03,
     TUNING_ESE_COMM_STATUS = 0x04,
     TUNING_ESE_UNDEF = 0xFF
   };

    enum tenESETuningCommandID {
      TUNING_SetCmd = 0x01,
      TUNING_GetCmd = 0x02
    };

   tVoid vSendAckToClient(tU8 u8ParameterID);
   tVoid vSendErrToClient(tU16 u16ErrorCode);
   tVoid vSetESEOnOff(tBool bOn);
   tVoid vGetESEOnOff();
   tVoid vSendESEOnOffData();

   tVoid vSetESEVolume(tU8 u8VolumeLevel);
   tVoid vGetESEVolume();
   tVoid vSendESEVolumeData();

   tVoid vSendESEParameter();

   tVoid vPrepareEseVersionResponse();
   tVoid vPrepareEseOnOffResponse(tU8* u8Data, tU32 u32Length);
   tVoid vPrepareEseVolumeResponse(tU8* u8Data, tU32 u32Length);
   tVoid vPrepareEseParameterResponse(tU8 u8FileId);
};

#endif /* ESETUNINGHANDLERRNAIVI_H_ */
