/**
 * @file ArkamysTuningHandlerRNAIVI.h
 * @author pau4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSTUNINGHANDLERRNAIVI_H_
#define ARKAMYSTUNINGHANDLERRNAIVI_H_


#include "ITuningDataClient.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "InternalComponentCommunication/Messages/mute/IDNotifyMute.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3ArkamysDefines.h"
#include "InternalComponentCommunication/Messages/Equ_Filter/IDSetFilter.h"
#include "mute/stream/StreamMute_IF.h"
#include "mute/stream/StreamMute.h"
//#include "mute/stream/StreamMuteNotify_IF.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_NotifyVolume.h"
#include "InternalComponentCommunication/Messages/Equ_Filter/IDNotifyFilter.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysMode.h"
#include "util/Macro.h"



#define TUNING_DATA_SERVICE_RESPONSE_HEADER_SIZE_IVI (7)
#define TUNING_MSG_FOOTER_VALUE (0xEE)
#define TUNING_BOSCH_LIB_ERROR_CODE (0xFFFF)
#define TUNING_DATA_OFFSET_IVI (4)
#define NO_OF_FILTER_PARAMETERS (3)
#define LEN_OF_FILTER_PARAMETERS (21)
#define MAX_LEN_OF_SDEQ_PARAMETERS (73)
#define AUD_PROC_READ_PARA_ID (521)
#define AUD_PROC_WRITE_PARA_ID (518)
#define AUD_PROC_WRITE_MULTI_FRAME_PARA_ID (605)
#define LENGTH_OFFSET (8)
/*
#define SWAP_32(_a) \
   (((_a       & 0xFF) << 24) | \
    ((_a >>  8 & 0xFF) << 16) | \
    ((_a >> 16 & 0xFF) <<  8) | \
    ((_a >> 24 & 0xFF)      ))
*/
class ArkamysTuningHandlerRNAIVI : public ITuningDataClient, public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   static ArkamysTuningHandlerRNAIVI* getInstance();
   tVoid DataRx(tU32 size, tVoid* pData, tU8 txHandle);
   tVoid AdrMessageRx(tU8 cmd, tU32 adr, tU32 len, tS32* data);
   tVoid IMXMessageRx(tU32 len, tU8* data);
   tVoid PublicParamMessageRx(tU8 u8PublicParam, tU8 u8data);
   tVoid FMEnhancer1MessageRx(tU8 u8PublicParam, SetFilterData data);
   tVoid SDEQMessageRx(tU32 len, tU8* pU8Data);
   virtual ~ArkamysTuningHandlerRNAIVI();
   tVoid vAdrOkCallback();

   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);

   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

   static tU8 u8FilterLenCount;

   tVoid vStoreAndSendSDEQParams(tU32 u32WriteLen, tU8* u8WriteData);

private:

   enum tenAdrErrorCode {
      ADR_ERR_WRONG_LENGTH          = 0x05,
      ADR_ERR_PARAM_OUT_OF_RANGE    = 0x06
   };

   enum tenTuningCommandID {
     TUNING_OpenCmd = 0x01,
     TUNING_CloseCmd = 0x02,
     TUNING_WriteCmd = 0x03,
     TUNING_ReadCmd = 0x04,
     TUNING_AckCmd = 0x10
   };

   enum tenTuningProcID {
     Tuning_Proc_Public = 0x00,
     Tuning_Proc_ADR3 = 0x01,
     Tuning_Proc_IMX6 = 0x02
   };

   enum tenTuningProcLibID {
     Tuning_Lib_Volume = 0x00,
     Tuning_Lib_Mute = 0x01,
     Tuning_Lib_SDEQ = 0x02,
     Tuning_Lib_FMEnhancer1 = 0x03,
     Tuning_Lib_ByPass = 0x04
   };

   ArkamysTuningHandlerRNAIVI();

   /**********variables**********/
   tU32 m_u32Size;
   tU8 *m_pU8Data;
   tU8 m_txHandle;
   tBool m_bHandleValid;
   tBool m_bCommExists; // used to check the communication has started
   tU8   m_u8MuteRegId;

   tU8 m_u8SDEQData[MAX_LEN_OF_SDEQ_PARAMETERS];

   tU8  m_u8FMEnhancer1Data[LEN_OF_FILTER_PARAMETERS];

   tBool m_bADR3SendReq;
   /**************flags to public parameters***********************/
   tBool m_bVolGetReq;
   tBool m_bMuteGetReq;
   tBool m_bMuteSetReq;
   tBool m_bByPassGetReq;
   tBool m_bFMEnhancerGetReq;

   //InternalCommunicationAdapter* pPO; // Pointer for post office access

   /******functions******/
   tVoid vSendAckToClient(tU8 u8CommandID);
   tVoid vSendErrToClient(tS16 s16ErrorCode);
   tVoid vSendData(); // entry function for sending data to ADR, iMX and public parameters
   tVoid vSendPublicParamData(); //public parameters
   tVoid vSendADR3Data(); //ADR3 parameters
   tVoid vSendIMXData(); //IMX6 parameters

   tVoid vSendVolume();
   tVoid vSendMute();
   tVoid vSendSDEQ();
   tVoid vSendFMEnhancer1();
   tVoid vSendByPass();

   tVoid vValidateADRCommand(const tU8* pData, tU32 length);

   tVoid Mute(tU8 muteReqId);
   tVoid Demute(tU8 muteReqId);


   /************setter functions****************/
   tVoid vSetVolume();
   tVoid vSetMuteDemute();
   tVoid vSetSDEQ();
   tVoid vSetFMEnhancer1();
   tVoid vSetByPass();

   tVoid vSetIMXData(tU32 u32WriteLen, tU8* u8WriteData, tS32 & s32ErrorCode, tU32 u32ParamID);

   /************getter functions****************/
   tVoid vGetVolume();
   tVoid vGetMuteDemute();
   tVoid vGetSDEQ();
   tVoid vGetFMEnhancer1();
   tVoid vGetByPass();

   tVoid vGetIMXData(tU32 u32WriteLen, tU8* u8WriteData, tU32 u32ReadLen);

};

#endif /* ARKAMYSTUNINGHANDLERRNAIVI_H_ */
