/**
 * @file ArkamysTuningHandler.h
 * @author CM-AI wie1hi
 * @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSTUNINGHANDLER_H_
#define ARKAMYSTUNINGHANDLER_H_

#include "ITuningDataClient.h"

class ArkamysTuningHandler : public ITuningDataClient
{
public:
   static ArkamysTuningHandler* getInstance();
   tVoid DataRx(tU32 size, tVoid* pData, tU8 txHandle);
   tVoid AdrMessageRx(tU8 cmd, tU32 adr, tU32 len, tS32* data);
   virtual ~ArkamysTuningHandler();
   tVoid vAdrOkCallback();
//   enum tenAdrOpType {
//      ArkamysOpTypeSet, ArkamysOpTypeGet, ArkamysOpTypeStatus, ArkamysOpTypeError
//   };
private:

   enum tenAdrErrorCode {
      ADR_ERR_WRONG_LENGTH          = 0x05,
      ADR_ERR_PARAM_OUT_OF_RANGE    = 0x06
   };

   //static ArkamysTuningHandler* m_pTheInstance;
   ArkamysTuningHandler();
   tU8 m_txHandle;
   tBool m_bHandleValid;
};

#endif /* ARKAMYSTUNINGHANDLER_H_ */
