/*************************************************************************
 *File          :  IDSettings.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDSETTINGS_H_
#define IDSETTINGS_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../DataTypes/TypeDefines/ADR3Settings.h"

/*******************************************************************************
 *
 * CLASS:MSG_Settings
 *
 *******************************************************************************/

class MSG_Settings: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_Settings(tenStream enStream, tenSettingType enSettingType, tS16 s16Step)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenStream enStream, tenSettingType enSettingType, tS16 s16Step
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   MSG_Settings(tenStream enstream, tenSettingType ensettingtype, tS16 s16steps) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_Settings), enStream(enstream), enSettingType(ensettingtype), s16Steps(s16steps)
   {
   }
   ;


   tenStream enStream;
   tenSettingType enSettingType;
   tS16 s16Steps;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual MSG_Settings *clone() const
   {
      return new MSG_Settings(*this);
   }
};

#endif /* IDSETTINGS_H_ */
