#ifndef IDSETMUTECHANNEL_H_
#define IDSETMUTECHANNEL_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../DataTypes/TypeDefines/MuteAction.h"

/*******************************************************************************
 *
 * CLASS:ID_SetMuteChannel
 *
 *******************************************************************************/

class ID_SetMuteChannel: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_SetMuteChannel(tenStream enStream, tenMuteAction enMuteAction, tU16 u16RampLin, tU16 u16RampdB)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream,enMuteAction,u8channelmask
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_SetMuteChannel(tenStream enstream, tU8 u8channelmask, tenMuteAction enmuteaction,tU16 u16RampLin,tU16 u16RampdB) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetMuteChannel), enStream(enstream), enMuteAction(enmuteaction), u8ChannelMask(u8channelmask),u16RmpLin(u16RampLin),u16RmpdB(u16RampdB)
   {
   }
   tenStream enStream;
   tenMuteAction enMuteAction;
   tU8 u8ChannelMask;
   tU16 u16RmpLin;
   tU16 u16RmpdB;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_SetMuteChannel *clone() const
   {
      return new ID_SetMuteChannel(*this);
   }
};

#endif /* IDSETMUTECHANNEL_H_ */
