/*************************************************************************
 *File          :  IDNotifySystemMute.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  20/08/2015     Vyankatesh VD       Initial version
 ************************************************************************/

#ifndef IDNOTIFYSYSTEMMUTE_H_
#define IDNOTIFYSYSTEMMUTE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../DataTypes/TypeDefines/MuteAction.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifyMute
 *
 *******************************************************************************/
class ID_NotifySystemMute: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifySystemMute(tU16 Requester,tU16 Resource,tU16 State,tU16 Reason)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: Resource,Source
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifySystemMute(tU16 requester,tU16 resource,tenMuteAction state,tU32 reason) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifySystemMute), Requester(requester), Resource(resource), State(state), Reason(reason)
   {
   }
   ;
   /**
    *The Integer values
    */
   tU16  Requester;
   tU16  Resource;
   tenMuteAction  State;
   tU32  Reason;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifySystemMute *clone() const
   {
      return new ID_NotifySystemMute(*this);
   }
};

#endif /* IDNOTIFYSYSTEMMUTE_H_ */
