/*************************************************************************
 *File          :  IDNotifyMute.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDNOTIFYMUTE_H_
#define IDNOTIFYMUTE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../DataTypes/TypeDefines/MuteAction.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifyMute
 *
 *******************************************************************************/

class ID_NotifyMute: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifyMute(tenStream enStream, tenMuteResult enMuteResult)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream,enMuteResult
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifyMute(tenStream enstream, tenMuteResult enmuteresult, tenSinks resource=Speaker) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifyMute), enStream(enstream), enMuteResult(enmuteresult), Sink(resource)
   {
   }
   ;


   tenStream enStream;
   tenMuteResult enMuteResult;
   tenSinks Sink;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifyMute *clone() const
   {
      return new ID_NotifyMute(*this);
   }
};

#endif /* IDCCASTARTMUTE_H_ */
