/*
 * IDCCACue.h
 *
 *  Created on: Dec 19, 2012
 *      Author: sea6kor
 */

#ifndef IDCCACUE_H_
#define IDCCACUE_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ExternItf/CCA/FI_Message/FI_Includes.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/VolOffset_CueType.h"

/*******************************************************************************
 *
 * CLASS:MSG_CueState
 *
 *******************************************************************************/

class MSG_CueState: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_CueState()
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: CueState
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  MSG_CueState(tenCueType CueState,tU16 Source) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCA_CueState),encuestate(CueState),ensource(Source)
    {
    }

  tenCueType encuestate;
  tU16 ensource;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_CueState *clone() const
   {
      return new MSG_CueState(*this);
   }
};



#endif /* IDCCACUE_H_ */
