/*
 * ID_ExtAmpADR_Volume.h
 *
 *  Created on: Feb 27, 2014
 *      Author: sea6kor
 */

#ifndef ID_EXTAMPADR_VOLUME_H_
#define ID_EXTAMPADR_VOLUME_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"

/*******************************************************************************
 *
 * CLASS:MSG_ExtAmpADR_Volume
 *
 *******************************************************************************/

class MSG_ExtAmpADR_Volume: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_ExtAmpADR_Volume(tenStream enstream, tU8 volstep, tS16 voldB , tU16 ramplin , tU16 rampdb)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenStream enstream, tU8 volstep, tS16 voldB , tU16 ramplin , tU16 rampdb
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   MSG_ExtAmpADR_Volume(tenStream enstream, tU8 volstep, tS16 voldB , tU16 ramplin , tU16 rampdb) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_ExtAmpADRVolume), enStream(enstream), VolStep(volstep), VoldB(voldB),
                                                                    RampLin(ramplin) ,RampdB(rampdb)
   {
   }
   ;

   tenStream enStream;
   tU8 VolStep;
   tS16 VoldB;
   tU16 RampLin;
   tU16 RampdB;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual MSG_ExtAmpADR_Volume *clone() const
   {
      return new MSG_ExtAmpADR_Volume(*this);
   }
};



#endif /* ID_EXTAMPADR_VOLUME_H_ */
