/*
 * IDSoundMode.h
 *
 *  Created on: Nov 16, 2012
 *      Author: hag2hi
 */

#ifndef IDSOUNDMODE_H_
#define IDSOUNDMODE_H_
#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"

/*******************************************************************************
 *
 * CLASS:MSG_SoundMode
 *
 *******************************************************************************/

class MSG_SoundMode: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_SoundMode(tenStream enStream, tU8 u8SoundModeMask)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream, u8SoundModeMask
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   MSG_SoundMode(tenStream enstream, tU8 u8soundmodemask) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SoundMode), enStream(enstream), u8SoundModeMask(u8soundmodemask)
   {
   }

   tenStream enStream;
   tU8 u8SoundModeMask;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_SoundMode* clone() const
   {
      return new MSG_SoundMode(*this);
   }
};




#endif /* IDSOUNDMODE_H_ */
