/************************************************************************FA*
 *File          :  IDSetSource.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 s*---------------------------------------------------------------------------
 Created by :  7/9/2012   7:16:47 PM   Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDSETSOURCE_H_
#define IDSETSOURCE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
//#include "../../DataTypes/TypeDefines/ADR3Source.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../DataTypes/TypeDefines/ADR3SourceType.h"

/*******************************************************************************
 *
 * CLASS:MSG_SetSource
 *
 *******************************************************************************/
class MSG_SetSource: public Message<PO_MessageConfig::enID>
{
public:

  /*******************************************************************************
   *
   * FUNCTION:  MSG_SetSource(tenStream enStream, tenSourceType  enSourceType)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream,enSourceType
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/

  MSG_SetSource(tenStream enstream, tenSourceType  ensourcetype, tU16 u16Audiosource, tU16 u16Sink) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetSource), enStream(enstream),enSourceType(ensourcetype),audioSource(u16Audiosource),sink(u16Sink)
    {
    }

  MSG_SetSource(const MSG_SetSource& pMsg) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetSource), enStream(pMsg.enStream),enSourceType(pMsg.enSourceType),audioSource(pMsg.audioSource),sink(pMsg.sink)
    {
    }

  tenStream enStream;
  tenSourceType enSourceType;
  tU16 audioSource;
  tU16 sink;

  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_SetSource *clone() const
   {
      return new MSG_SetSource(*this);
   }
};

#endif /* IDSETSOURCE_H_ */
