/************************************************************************FA*
 *File         :  IDSequenceCtrl.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  7/9/2012   7:14:21 PM   Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDSEQUENCECTRL_H_
#define IDSEQUENCECTRL_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"


enum tenAutoParameterUpdate
{
  EN_AUDIO_SOURCE_AutoParameterUpdate_OFF = 0x00,
  EN_AUDIO_SOURCE_AutoParameterUpdate_ON = 0x01
};

/*******************************************************************************
 *
 * CLASS:MSG_SequenceCtrl
 *
 *******************************************************************************/
class MSG_SequenceCtrl: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_SequenceCtrl(tenAutoParameterUpdate enAutoParameterUpdate)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enAutoParameterUpdate
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  MSG_SequenceCtrl(tenAutoParameterUpdate enautoparameterupdate) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SequenceCtrl), enAutoParameterUpdate(enautoparameterupdate)
    {
    }

  MSG_SequenceCtrl(const MSG_SequenceCtrl& pMsg) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SequenceCtrl), enAutoParameterUpdate(pMsg.enAutoParameterUpdate)
    {
    }

  tenAutoParameterUpdate enAutoParameterUpdate;

  /*******************************************************************************
   *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_SequenceCtrl *clone() const
   {
      return new MSG_SequenceCtrl(*this);
   }
};

#endif /* IDSEQUENCECTRL_H_ */
