
/************************************************************************FA*
 *File         :  IDCCAStartAudioSource.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  7/9/2012   7:13:02 PM   Anu Sebastian       Initial version
 ************************************************************************/
#ifndef IDCCASTARTAUDIOSOURCE_H_
#define IDCCASTARTAUDIOSOURCE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_CCAStart_AudioSource
 *
 *******************************************************************************/

class ID_CCAStart_AudioSource: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_CCAStart_AudioSource(tU16 Resource,tU16 Source)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: Resource,Source
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_CCAStart_AudioSource(tU16 resource,tU16 source) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_AudioSource), Resource(resource),Source(source)
   {
     uChannel = 0;
   }

   ID_CCAStart_AudioSource(tU16 resource,tU16 source, tU16 Channel) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_AudioSource), Resource(resource),Source(source),uChannel(Channel)
   {
   }

   ID_CCAStart_AudioSource(const ID_CCAStart_AudioSource& pMsg) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_AudioSource), Resource(pMsg.Resource),Source(pMsg.Source),uChannel(pMsg.uChannel)
   {
   }

   /**
    *The Integer value
    */
   tU16  Resource;
   tU16  Source;
   tU16  uChannel;


    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_CCAStart_AudioSource* clone() const
   {
      return new ID_CCAStart_AudioSource(*this);
   }
};

#endif /* IDCCASTARTAUDIOSOURCE_H_ */
