/*************************************************************************
 *File          :  IDNotifySoundConfigVersion.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDNOTIFY_SOUND_CONFIG_VERSION_H_
#define IDNOTIFY_SOUND_CONFIG_VERSION_H_


#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
//#include "../../DataTypes/TypeDefines/ADR3Startup.h"
//#include "../../DataTypes/TypeDefines/MuteAction.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifySoundConfigVersion
 *
 *******************************************************************************/

class ID_NotifySoundConfigVersion: public Message<PO_MessageConfig::enID>
{
public:
   enum tenValidity {enOK = 0, enUnhandledFileID, enError};

  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifySoundConfigVersion(tU8 _u8FileID, tU32 _u32Version, tU32 _u32CRC)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: _u8FileID,_u32Version,_u32CRC
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/

   ID_NotifySoundConfigVersion(tU8 _u8FileID, tU32 _u32Version, tU32 _u32CRC, tenValidity _enValid = enOK) :
      Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifySoundConfigVersion),
      u8FileID(_u8FileID),
      u32Version(_u32Version),
      u32CRC(_u32CRC),
      enIsValid(_enValid)
   {
   }

   tU8  u8FileID;
   tU32 u32Version;
   tU32 u32CRC;
   tenValidity enIsValid;  // can indicate error response from ADR

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifySoundConfigVersion *clone() const
   {
      return new ID_NotifySoundConfigVersion(*this);
   }
};

#endif /* IDNOTIFY_SOUND_CONFIG_VERSION_H_ */
