/*************************************************************************
 *File          :  IDNotifySoundConfigVersion.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDNOTIFY_SEND_SOUND_CONFIG_FILE_H_
#define IDNOTIFY_SEND_SOUND_CONFIG_FILE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifySoundConfigVersion
 *
 *******************************************************************************/

class ID_NotifySendSoundConfigFile: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifySendSoundConfigFile(tU8 _u8FileID, tU8* _pu8File, tU32 _u32Length)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: _u8FileID, tU8* _pu8File, _u32Length
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifySendSoundConfigFile(tU8 _u8FileID, tPCUChar _pu8File, tU32 _u32Length) :
      Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifySendSoundConfigFile),
      u8FileID(_u8FileID),
      pu8File(_pu8File),
      u32Length(_u32Length)
   {
   }
   ;
   tU8  u8FileID;
   tPCUChar pu8File;
   tU32 u32Length;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifySendSoundConfigFile *clone() const
   {
      return new ID_NotifySendSoundConfigFile(*this);
   }
};

#endif /* IDNOTIFY_SEND_SOUND_CONFIG_FILE_H_ */
