/**
* @file ID_ArkamysFeature.h
* @author CM-AI wie1hi - EXTERNAL Wilhelmi Erik
* @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
* @addtogroup fc_audiomanager
* @{
*/

#ifndef ID_ARKAMYSFEATURE_H_
#define ID_ARKAMYSFEATURE_H_

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
#include "../../../Arkamys/PSA/ArkamysConfig.h"
#else
#include "../../../Arkamys/RNAIVI/ArkamysConfigRNAIVI.h"
#endif

class ID_ArkamysFeature: public Message<PO_MessageConfig::enID>
{
public:
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
   ID_ArkamysFeature() : Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_ArkamysFeature),
      enArkamysFeature(ArkamysConfig::ARKAMYS_FEATURE_INVALID), u16ArkamysParameter(0)
   {
   }

   ArkamysConfig::tenArkamysFeature enArkamysFeature;
   tU16 u16ArkamysParameter;
#else
   ID_ArkamysFeature() : Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_ArkamysFeature),
      enArkamysFeature(ArkamysConfigRNAIVI::ARKAMYS_FEATURE_INVALID), u16ArkamysParameter(0)
   {
   }

   ArkamysConfigRNAIVI::tenArkamysFeature enArkamysFeature;
   tU16 u16ArkamysParameter;
#endif
   /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_ArkamysFeature *clone() const
   {
      return new ID_ArkamysFeature(*this);
   }
};

#endif /* ID_ARKAMYSFEATURE_H_ */
