/*************************************************************************
 *File          :  IDDiagRemoteControl.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  04/02/2013     Gaidatzi-Lken       Initial version
 ************************************************************************/

#ifndef IDDIAGREMOTECONTROL_H_
#define IDDIAGREMOTECONTROL_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/DiagRemoteControlType.h"

/*******************************************************************************
 *
 * CLASS:ID_DiagRemoteControl
 *
 *******************************************************************************/

class ID_DiagRemoteControl: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_DiagRemoteControl(tenRemoteControlPhase enRemoteControlPhase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagRemoteControlPhase enDiagRemoteControlPhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagRemoteControl(tenDiagRemoteControlPhase endiagRemoteControlphase) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagRemoteControl), enDiagRemoteControlPhase(endiagRemoteControlphase)
    {
    }

  tenDiagRemoteControlPhase enDiagRemoteControlPhase;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagRemoteControl *clone() const
  {
    return new ID_DiagRemoteControl(*this);
  }
};

#endif /* IDDIAGREMOTECONTROL_H_ */
