/*************************************************************************
 *File          :  IDDiagAudioGain.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  04/02/2013     Gaidatzi-Lken       Initial version
 ************************************************************************/

#ifndef IDDIAGAUDIOGAIN_H_
#define IDDIAGAUDIOGAIN_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"


/*******************************************************************************
 *
 * CLASS:ID_DiagAudioGain
 *
 *******************************************************************************/

class ID_DiagAudioGain: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_DiagAudioGain(tenAudioGainPhase enAudioGainPhase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagAudioGainPhase enDiagAudioGainPhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagAudioGain(tS8 saudiogainvalue) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagAudioGain), sAudioGainValue(saudiogainvalue)
    {
    }

  tS8 sAudioGainValue;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagAudioGain *clone() const
  {
    return new ID_DiagAudioGain(*this);
  }
};

#endif /* IDDIAGAUDIOGAIN_H_ */
