/*
 * IDSignalTone.h
 *
 *  Created on: Oct 19, 2012
 *      Author: sea6kor
 */

#ifndef IDSIGNALTONE_H_
#define IDSIGNALTONE_H_
#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:MSG_SignalTone
 *
 *******************************************************************************/

class MSG_SignalTone: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_SignalTone(tU8 SignalToneType, tU8 SignalToneAction)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: SignalToneType, SignalToneAction
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   MSG_SignalTone(tU8 signaltonetype, tU8 signaltoneaction) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SignalTone), SignalToneType(signaltonetype), SignalToneAction(signaltoneaction)
   {
   }

   tU8 SignalToneType;
   tU8 SignalToneAction;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_SignalTone* clone() const
   {
      return new MSG_SignalTone(*this);
   }
};




#endif /* IDSIGNALTONE_H_ */
