/*************************************************************************
 *File          :  IDNotifyChimeParameters.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Klotz       Initial version
 ************************************************************************/

#ifndef IDNOTIFYCHIMEPARAMETERS_H_
#define IDNOTIFYCHIMEPARAMETERS_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3NotifyBeep.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifyChimeParameters
 *
 *******************************************************************************/

class ID_NotifyChimeParameters: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifyChimeParameters(tenBeepState enBeepState)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enBeepState
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifyChimeParameters(tenBeepState enbeepstate) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifyChimeParameters),  enBeepState(enbeepstate)
   {
   }
   ;

   tenBeepState enBeepState;


  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifyChimeParameters *clone() const
   {
      return new ID_NotifyChimeParameters(*this);
   }
};

#endif /* IDNOTIFYCHIMEPARAMETERS_H_ */
