
/************************************************************************FA*
 *File         :  IDNotifyBeepState.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Ramesh Babu K(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  21/12/2012   Ramesh Babu K       Initial version
 ************************************************************************/
#ifndef IDNOTIFYBEEPSTATE_H_
#define IDNOTIFYBEEPSTATE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifyBeepState
 *
 *******************************************************************************/

class ID_NotifyBeepState: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifyBeepState(BeepType,Resource)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: BeepType,Resource
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifyBeepState(tU8 beeptype, tU8 beepstate) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifyBeepState), BeepType(beeptype), BeepState(beepstate)
   {
   }

   tU8 BeepType;
   tU8 BeepState;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_NotifyBeepState* clone() const
   {
      return new ID_NotifyBeepState(*this);
   }
};

#endif /* IDNOTIFYBEEPSTATE_H_ */
