/************************************************************************FA*
 *File         :  IDNotifyBeepFileStatus.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2015 Robert Bosch GmbH, Hildesheim
 *Author            : Ranjit K (RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  6/8/2015   Ranjit K       Initial version
 ************************************************************************/
#ifndef IDNOTIFYBEEPFILESTATUS_H_
#define IDNOTIFYBEEPFILESTATUS_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifyBeepFileStatus
 *
 *******************************************************************************/

class ID_NotifyBeepFileStatus: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifyAudioTestToneStatus(ChannelSelect,TestToneState)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: ChannelSelect,TestToneState
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_NotifyBeepFileStatus(tU8 channelselect, tU8 beepfilestate) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifyBeepFileStatus), ChannelSelect(channelselect), BeepPlaystate(beepfilestate)
   {
   }

   tU8 ChannelSelect;
   tU8 BeepPlaystate;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_NotifyBeepFileStatus* clone() const
   {
      return new ID_NotifyBeepFileStatus(*this);
   }
};

#endif /* IDNOTIFYBEEPFILESTATUS_H_ */
