
/************************************************************************FA*
 *File         :  IDCCAStartBeep.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  7/9/2012   7:13:02 PM   Anu Sebastian       Initial version
 ************************************************************************/
#ifndef IDCCASTARTBEEP_H_
#define IDCCASTARTBEEP_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_CCAStart_Beep
 *
 *******************************************************************************/

class ID_CCAStart_Beep: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_CCAStart_Beep(BeepType,Resource)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: BeepType,Resource
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_CCAStart_Beep(tU8 beeptype,tU8 resource) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_Beep), BeepType(beeptype),Resource(resource)
   {
   }

   ID_CCAStart_Beep(const ID_CCAStart_Beep& pMsg) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_Beep), BeepType(pMsg.BeepType),Resource(pMsg.Resource)
   {}

   /**
    *The Integer value
    */
   tU8  BeepType;
   tU8  Resource;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_CCAStart_Beep* clone() const
   {
      return new ID_CCAStart_Beep(*this);
   }
};

#endif /* IDCCASTARTBEEP_H_ */
