
/************************************************************************FA*
 *File         :  IDCCAStartADASBeep.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2016 Robert Bosch GmbH, Hildesheim
 *Author            : rej1kor
 ************************************************************************/
#ifndef IDCCASTART_ADASBEEP_H_
#define IDCCASTART_ADASBEEP_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_CCAStart_ADASBeep
 *
 *******************************************************************************/

class ID_CCAStart_ADASBeep: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_CCAStart_ADASBeep(SettingType)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: SettingType
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_CCAStart_ADASBeep(tU8 u8BeepType,tU8 u8RecurrenceType,tU8 u8ChannelZone) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_ADASBeep), m_u8BeepType(u8BeepType),m_u8RecurrenceType(u8RecurrenceType),m_u8ChannelZone(u8ChannelZone)
   {
   }

   ID_CCAStart_ADASBeep(const ID_CCAStart_ADASBeep& pMsg) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_ADASBeep), m_u8BeepType(pMsg.m_u8BeepType),m_u8RecurrenceType(pMsg.m_u8RecurrenceType),m_u8ChannelZone(pMsg.m_u8ChannelZone)
   {}

   /**
    *The Integer value
    */
   tU8 m_u8BeepType;
   tU8 m_u8RecurrenceType;
   tU8 m_u8ChannelZone;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_CCAStart_ADASBeep* clone() const
   {
      return new ID_CCAStart_ADASBeep(*this);
   }
};

#endif /* IDCCASTART_ADASBEEP_H_ */
