///////////////////////////////////////////////////////////
//  ApplicationStateTypeConverter.h
//  Implementation of the Class ApplicationStateTypeConverter
//  Created on:      06.12.2012
///////////////////////////////////////////////////////////

#if !defined(ApplicationStateTypeConverter__INCLUDED_)
#define ApplicationStateTypeConverter__INCLUDED_
#define SYSTEM_S_IMPORT_INTERFACE_COMPLETE
#include "system_pif.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../TypeDefines/ApplicationStateDefines.h"
#include "TypeConverterMap.h"

#include "CCA/FI_Message/FI_Includes.h"

/**
 * This class (a) defines an Instance operation that lets clients access its unique instance, and (b) may be responsible for creating its own
 * unique instance.
 */
class ApplicationStateTypeConverter
{

public:
   tenApplicationStates getInternalUsedTypeForApplicationState(tU32 seachEntity);
   tenApplicationStates getInternalUsedTypeForVoltageState(tU32 seachEntity);
   tenApplicationStates getInternalUsedTypeForCoproState(tU32 seachEntity);

   static ApplicationStateTypeConverter* getInstance();
   tVoid attachData ();

private:
   ApplicationStateTypeConverter();
   /**
    * Map of stream type from CCA define to ADR3 define
    */
   TypeConverterMap <tU32, tenApplicationStates> m_TypeConverterMapAppStateTypeToInternalType;
   TypeConverterMap <tU32, tenApplicationStates> m_TypeConverterMapProcStateToInternalState;
   TypeConverterMap <tU32, tenApplicationStates> m_TypeConverterMapCVMStateToInternalState;
   static ApplicationStateTypeConverter* pInstance;

};
#endif

